/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.core;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.net.UnknownHostException;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.zaiyers.UUIDDB.core.MongoStorage;
import net.zaiyers.UUIDDB.core.Storage;
import net.zaiyers.UUIDDB.core.StorageException;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;
import net.zaiyers.UUIDDB.lib.mongodb.MongoException;

public class CachedStorage
implements Storage {
    private final LoadingCache<UUID, String> nameCache;
    private final LoadingCache<String, UUID> uuidCache;
    private Storage storage;

    public CachedStorage(UUIDDBPlugin plugin, Storage.Config config, int size) throws UnknownHostException, ClassNotFoundException, StorageException {
        this.nameCache = CacheBuilder.newBuilder().maximumSize((long)size).build((CacheLoader)new CacheLoader<UUID, String>(){

            public String load(UUID uuid) throws Exception {
                if (CachedStorage.this.storage != null) {
                    return CachedStorage.this.storage.getNameByUUID(uuid);
                }
                return null;
            }
        });
        this.uuidCache = CacheBuilder.newBuilder().maximumSize((long)size).build((CacheLoader)new CacheLoader<String, UUID>(){

            public UUID load(String name) throws Exception {
                String uuidStr;
                if (CachedStorage.this.storage != null && (uuidStr = CachedStorage.this.storage.getUUIDByName(name)) != null) {
                    return UUID.fromString(uuidStr);
                }
                return null;
            }
        });
        if ("mongo".equalsIgnoreCase(config.getType())) {
            try {
                this.storage = new MongoStorage(plugin, config);
            }
            catch (MongoException e) {
                throw new StorageException(e.getMessage(), e);
            }
        } else if (!"cached".equalsIgnoreCase(config.getType())) {
            throw new ClassNotFoundException(config.getType() + " storage is not a valid option!");
        }
    }

    @Override
    public void disable() {
        if (this.storage != null) {
            this.storage.disable();
        }
    }

    @Override
    public String getNameByUUID(UUID uuid) {
        try {
            return (String)this.nameCache.get((Object)uuid);
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }

    @Override
    public String getNameByUUID(String uuid) {
        return this.getNameByUUID(UUID.fromString(uuid));
    }

    @Override
    public void insert(UUID uniqueId, String name) {
        if (this.storage != null) {
            this.storage.insert(uniqueId, name);
            this.nameCache.refresh((Object)uniqueId);
            this.uuidCache.refresh((Object)name);
        }
    }

    @Override
    public boolean exists(UUID uuid, String name) {
        String stored = this.getNameByUUID(uuid);
        return stored != null && stored.equals(name);
    }

    @Override
    public String getUUIDByName(String name) {
        try {
            UUID uuid = (UUID)this.uuidCache.get((Object)name);
            return uuid == null ? null : uuid.toString();
        }
        catch (ExecutionException e) {
            return null;
        }
        catch (CacheLoader.InvalidCacheLoadException e) {
            return null;
        }
    }

    @Override
    public String getUUIDByName(String name, boolean casesensitive) {
        if (casesensitive) {
            return this.getUUIDByName(name);
        }
        if (this.storage != null) {
            return this.storage.getUUIDByName(name, casesensitive);
        }
        return null;
    }
}

