/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;
import net.zaiyers.UUIDDB.bungee.PlayerJoinListener;
import net.zaiyers.UUIDDB.bungee.UuidDbCommand;
import net.zaiyers.UUIDDB.core.CachedStorage;
import net.zaiyers.UUIDDB.core.Storage;
import net.zaiyers.UUIDDB.core.StorageException;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;

public class UUIDDB
extends Plugin
implements UUIDDBPlugin {
    private Storage storage;
    private Configuration cfg;
    protected static final ConfigurationProvider ymlCfg = ConfigurationProvider.getProvider(YamlConfiguration.class);
    private boolean enabled = false;

    public void onEnable() {
        try {
            this.loadConfig();
        }
        catch (IOException e) {
            this.getLogger().severe("Can not load configuration. UUIDDB will not be enabled.");
            e.printStackTrace();
            return;
        }
        String mongoHost = this.getConfig().getString("mongo.host", "localhost");
        String storageType = this.getConfig().getString("storage", "mongo");
        try {
            Object dV = this.getConfig().get(storageType);
            Object dO = this.getConfig().getDefault(storageType);
            HashMap<String, Object> values = new HashMap();
            HashMap<String, Object> defaults = new HashMap();
            if (dV != null && dV instanceof Map) {
                values = (Map)dV;
            }
            if (dO != null && dO instanceof Map) {
                defaults = (Map)dO;
            }
            this.storage = new CachedStorage(this, new Storage.Config(storageType, values, defaults), this.getConfig().getInt("cachesize", 1000));
            if (this.getConfig().getBoolean("log")) {
                this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new PlayerJoinListener(this));
            }
            this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new UuidDbCommand(this, "uuiddb", "uuiddb.command", "uuidinfo", "uuid"));
        }
        catch (UnknownHostException e) {
            this.getLogger().severe("Unknown host: " + mongoHost);
            return;
        }
        catch (StorageException e) {
            this.getLogger().severe(e.getMessage());
            e.printStackTrace();
            this.getLogger().severe("Failed to connect to mongodb");
            return;
        }
        catch (ClassNotFoundException e) {
            this.getLogger().severe(e.getMessage());
            return;
        }
        this.enabled = true;
    }

    public void onDisable() {
        this.getStorage().disable();
    }

    @Deprecated
    public static UUIDDB getInstance() {
        return (UUIDDB)ProxyServer.getInstance().getPluginManager().getPlugin("UUIDDB");
    }

    @Override
    public Storage getStorage() {
        return this.storage;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    @Deprecated
    public String getNameByUUID(UUID uuid) {
        return this.getNameByUUID(uuid.toString());
    }

    @Override
    @Deprecated
    public String getNameByUUID(String uuid) {
        return this.getStorage().getNameByUUID(uuid);
    }

    @Override
    @Deprecated
    public void insert(UUID uniqueId, String name) {
        this.getStorage().insert(uniqueId, name);
    }

    @Override
    @Deprecated
    public boolean exists(UUID uuid, String name) {
        return this.getStorage().exists(uuid, name);
    }

    @Override
    @Deprecated
    public String getUUIDByName(String name) {
        return this.getStorage().getUUIDByName(name);
    }

    @Override
    @Deprecated
    public String getUUIDByName(String name, boolean casesensitive) {
        return this.getStorage().getUUIDByName(name, casesensitive);
    }

    private void loadConfig() throws IOException {
        if (this.cfg == null) {
            File configFile = new File(String.valueOf(this.getDataFolder().getAbsoluteFile()) + "/config.yml");
            if (!configFile.exists()) {
                if (!configFile.getParentFile().exists()) {
                    configFile.getParentFile().mkdirs();
                }
                configFile.createNewFile();
                this.cfg = ymlCfg.load(configFile);
                InputStreamReader isr_cfg = new InputStreamReader(this.getResourceAsStream("config.yml"));
                this.cfg = ymlCfg.load((Reader)isr_cfg);
                ymlCfg.save(this.cfg, configFile);
            } else {
                this.cfg = ymlCfg.load(configFile);
            }
        }
    }

    private Configuration getConfig() {
        return this.cfg;
    }
}

