/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.UUIDDB.bungee;

import java.util.UUID;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Plugin;
import net.zaiyers.UUIDDB.bungee.UUIDDB;

public class UuidDbCommand
extends Command {
    private final UUIDDB plugin;

    public UuidDbCommand(UUIDDB plugin, String name, String permission, String ... aliases) {
        super(name, permission, aliases);
        this.plugin = plugin;
    }

    public void execute(final CommandSender sender, String[] args) {
        if (args.length > 0) {
            for (String arg : args) {
                UUID uuid = null;
                String username = null;
                ProxiedPlayer player = null;
                try {
                    uuid = UUID.fromString(arg);
                    player = this.plugin.getProxy().getPlayer(uuid);
                }
                catch (IllegalArgumentException e) {
                    username = arg;
                    player = this.plugin.getProxy().getPlayer(username);
                }
                if (player != null) {
                    this.sendInfo(sender, player.getName(), player.getUniqueId().toString());
                    continue;
                }
                if (uuid != null) {
                    final UUID finalUuid = uuid;
                    this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            String name = UuidDbCommand.this.plugin.getStorage().getNameByUUID(finalUuid);
                            if (name != null) {
                                String uuidStr = UuidDbCommand.this.plugin.getStorage().getUUIDByName(name, false);
                                UuidDbCommand.this.sendInfo(sender, name, uuidStr);
                            } else {
                                sender.sendMessages(new String[]{String.valueOf(ChatColor.RED) + "No Username for UUID " + String.valueOf(finalUuid) + " found!"});
                            }
                        }
                    });
                    continue;
                }
                if (username != null) {
                    final String finalUsername = username;
                    this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, new Runnable(){

                        @Override
                        public void run() {
                            String uuidStr = UuidDbCommand.this.plugin.getStorage().getUUIDByName(finalUsername, false);
                            if (uuidStr != null) {
                                String name = UuidDbCommand.this.plugin.getStorage().getNameByUUID(uuidStr);
                                UuidDbCommand.this.sendInfo(sender, name, uuidStr);
                            } else {
                                sender.sendMessages(new String[]{String.valueOf(ChatColor.RED) + "No UUID for username " + finalUsername + " found!"});
                            }
                        }
                    });
                    continue;
                }
                sender.sendMessages(new String[]{String.valueOf(ChatColor.RED) + "Something went wrong! Please report this to a developer!"});
                this.plugin.getLogger().log(Level.WARNING, "Everything is null! Sender: " + sender.getName() + ", Argument: " + arg);
            }
        } else if (this.plugin.isEnabled()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + this.plugin.getDescription().getName() + " v" + this.plugin.getDescription().getVersion() + " by " + this.plugin.getDescription().getAuthor());
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage: /" + this.getName() + " <uuid|username>");
        } else {
            sender.sendMessage(String.valueOf(ChatColor.RED) + this.plugin.getDescription().getName() + " did not enable correctly!");
        }
    }

    private void sendInfo(CommandSender sender, String username, String uuid) {
        sender.sendMessage(new ComponentBuilder("Username: ").color(ChatColor.GREEN).append(username).color(ChatColor.YELLOW).event(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, username)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(String.valueOf(ChatColor.YELLOW) + "Click to copy this name").create())).append("\n").append("UUID: ").color(ChatColor.GREEN).append(uuid).color(ChatColor.YELLOW).event(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, uuid)).event(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(String.valueOf(ChatColor.YELLOW) + "Click to copy this uuid").create())).create());
    }
}

