/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.zaiyers.ChannelsAutoban.ChannelsAutoban;
import org.slf4j.event.Level;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.yaml.NodeStyle;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class FileConfiguration {
    private static final Pattern PATH_PATTERN = Pattern.compile("\\.");
    private final ChannelsAutoban plugin;
    private final Path configFile;
    private final String defaultFile;
    private final YamlConfigurationLoader configLoader;
    private ConfigurationNode config;
    private ConfigurationNode defaultConfig;

    public FileConfiguration(ChannelsAutoban plugin, Path configFile) {
        this(plugin, configFile, configFile.getFileName().toString());
    }

    public FileConfiguration(ChannelsAutoban plugin, Path configFile, String defaultFile) {
        this.plugin = plugin;
        this.configFile = configFile;
        this.defaultFile = defaultFile;
        this.configLoader = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).path(configFile)).nodeStyle(NodeStyle.BLOCK).build();
    }

    public boolean load() {
        try {
            this.config = this.configLoader.load();
            if (this.defaultFile != null) {
                try (InputStream defaultConfigStream = this.plugin.getClass().getClassLoader().getResourceAsStream(this.defaultFile);){
                    if (defaultConfigStream != null) {
                        this.defaultConfig = ((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().indent(2).source(() -> new BufferedReader(new InputStreamReader(defaultConfigStream)))).build().load();
                        if (this.config.empty()) {
                            this.config = this.defaultConfig.copy();
                        }
                    }
                }
            }
            this.plugin.log(Level.INFO, "Loaded " + String.valueOf(this.configFile.getFileName()));
            return true;
        }
        catch (IOException e) {
            this.plugin.log(Level.ERROR, "Unable to load configuration file " + String.valueOf(this.configFile.getFileName()), e);
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean createDefaultConfig() throws IOException {
        block14: {
            try (InputStream in = this.plugin.getClass().getClassLoader().getResourceAsStream(this.defaultFile);){
                if (in == null) {
                    this.plugin.log(Level.WARN, "No default config '" + this.defaultFile + "' found in " + this.plugin.getClass().getSimpleName() + "!");
                    boolean bl = false;
                    return bl;
                }
                if (Files.exists(this.configFile, new LinkOption[0])) break block14;
                Path parent = this.configFile.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                try {
                    Files.copy(in, this.configFile, new CopyOption[0]);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    this.plugin.log(Level.ERROR, "Could not save " + String.valueOf(this.configFile.getFileName()) + " to " + String.valueOf(this.configFile), ex);
                }
            }
            catch (IOException ex) {
                this.plugin.log(Level.ERROR, "Could not load default config from " + this.defaultFile, ex);
            }
        }
        return false;
    }

    public void save() {
        try {
            this.configLoader.save(this.config);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Object set(String path, Object value) {
        ConfigurationNode node = this.config.node(FileConfiguration.splitPath(path));
        Object prev = node.raw();
        try {
            node.set(value);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        return prev;
    }

    public ConfigurationNode remove(String path) {
        ConfigurationNode node = this.config.node(FileConfiguration.splitPath(path));
        try {
            return node.virtual() ? node : node.set(null);
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public ConfigurationNode getRawConfig() {
        return this.config;
    }

    public ConfigurationNode getRawConfig(String path) {
        return this.getRawConfig().node(FileConfiguration.splitPath(path));
    }

    public boolean has(String path) {
        return !this.getRawConfig(path).virtual();
    }

    public boolean isSection(String path) {
        return !this.getRawConfig(path).childrenMap().isEmpty();
    }

    public Map<String, Object> getSection(String key) {
        return FileConfiguration.getConfigMap(this.getRawConfig(key));
    }

    public int getInt(String path) {
        return this.getInt(path, this.defaultConfig != null ? this.defaultConfig.node(FileConfiguration.splitPath(path)).getInt() : 0);
    }

    public int getInt(String path, int def) {
        return this.getRawConfig(path).getInt(def);
    }

    public double getDouble(String path) {
        return this.getDouble(path, this.defaultConfig != null ? this.defaultConfig.node(FileConfiguration.splitPath(path)).getDouble() : 0.0);
    }

    public double getDouble(String path, double def) {
        return this.getRawConfig(path).getDouble(def);
    }

    public String getString(String path) {
        return this.getString(path, this.defaultConfig != null ? this.defaultConfig.node(FileConfiguration.splitPath(path)).getString() : null);
    }

    public String getString(String path, String def) {
        ConfigurationNode node = this.getRawConfig(path);
        if (def != null) {
            return node.getString(def);
        }
        return node.getString();
    }

    public List<String> getStringList(String path) {
        try {
            return this.getRawConfig(path).getList(String.class);
        }
        catch (SerializationException e) {
            this.plugin.log(Level.ERROR, "Expected " + path + " to be a list of strings in " + this.defaultFile + " but it wasn't?", e);
            return List.of();
        }
    }

    public boolean getBoolean(String path) {
        return this.getBoolean(path, this.defaultConfig != null && this.defaultConfig.node(FileConfiguration.splitPath(path)).getBoolean());
    }

    public boolean getBoolean(String path, boolean def) {
        return this.getRawConfig(path).getBoolean(def);
    }

    private static Object[] splitPath(String key) {
        return PATH_PATTERN.split(key);
    }

    public static Map<String, Object> getConfigMap(Object configuration) {
        if (configuration instanceof Map) {
            return FileConfiguration.getValues((Map)configuration);
        }
        if (configuration instanceof ConfigurationNode) {
            return FileConfiguration.getValues((ConfigurationNode)configuration);
        }
        return null;
    }

    private static Map<String, Object> getValues(ConfigurationNode config) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : config.childrenMap().entrySet()) {
            String key = String.valueOf(entry.getKey());
            ConfigurationNode value = (ConfigurationNode)entry.getValue();
            if (value.isMap()) {
                map.put(key, FileConfiguration.getValues(value));
                continue;
            }
            map.put(key, value.raw());
        }
        return map;
    }

    private static Map<String, Object> getValues(Map<?, ?> map) {
        LinkedHashMap<String, Object> returnMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = String.valueOf(entry.getKey());
            if (entry.getValue() instanceof Map) {
                returnMap.put(key, FileConfiguration.getValues((Map)entry.getValue()));
                continue;
            }
            if (entry.getValue() instanceof ConfigurationNode) {
                returnMap.put(key, FileConfiguration.getValues((ConfigurationNode)entry.getValue()));
                continue;
            }
            returnMap.put(key, entry.getValue());
        }
        return returnMap;
    }
}

