/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.proxy.Player;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.Message;
import net.zaiyers.ChannelsAutoban.ChannelsAutoban;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanPattern;
import org.slf4j.event.Level;

public class ChannelsMessageListener {
    private static final Pattern IPPattern = Pattern.compile(".*?([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})(:[0-9]{3,5}|).*?");
    private final ChannelsAutoban plugin;
    private Map<UUID, Cache<String, Message>> msgHistory = new HashMap<UUID, Cache<String, Message>>();
    private int ttl = 0;
    private float rate = 0.0f;
    private ChannelsAutobanPattern spamPattern;
    private boolean denyRepeat = false;

    public ChannelsMessageListener(ChannelsAutoban plugin) {
        this.plugin = plugin;
        Map<String, Object> spamCfg = plugin.getConfig().getSection("counters.spam");
        if (spamCfg != null) {
            this.ttl = (Integer)spamCfg.get("ttl");
            if (this.ttl < 0) {
                this.ttl = 0;
            }
            this.rate = ((Float)spamCfg.get("rate")).floatValue();
            this.denyRepeat = (Boolean)spamCfg.get("deny-repeat");
            HashMap<String, Object> spamPatternCfg = new HashMap<String, Object>();
            spamPatternCfg.put("counter", "spam");
            this.spamPattern = new ChannelsAutobanPattern(spamPatternCfg);
            plugin.log(Level.INFO, "Spam config: ttl=" + this.ttl + "s, rate=" + this.rate + ", denyRepeat=" + this.denyRepeat);
        }
    }

    @Subscribe
    public void onChannelsMessage(ChannelsChatEvent e) {
        Object object;
        if (e.isCancelled() || !((object = e.getMessage().getSender()) instanceof Player)) {
            return;
        }
        Player p = (Player)object;
        if (p.hasPermission("autoban.exempt")) {
            return;
        }
        for (ChannelsAutobanPattern pattern : this.plugin.getPatterns()) {
            Matcher matcher = pattern.matcher(e.getMessage().getRawMessage());
            if (!matcher.matches()) continue;
            this.plugin.increaseCounter(p, pattern, e.getMessage(), matcher);
            if (pattern.doHide()) {
                e.setHidden(true);
                continue;
            }
            if (pattern.getReplace() == null) continue;
            e.getMessage().setRawMessage(matcher.replaceAll(pattern.getReplace()));
        }
        Matcher ipMatcher = IPPattern.matcher(e.getMessage().getRawMessage());
        if (ipMatcher.matches()) {
            String host = ChannelsMessageListener.getHost(e.getMessage().getRawMessage());
            int port = ChannelsMessageListener.getPort(e.getMessage().getRawMessage());
            if (!this.plugin.getIPWhitelist().contains(host) && this.serverAlive(host, port)) {
                if (this.plugin.getIPPattern().doHide()) {
                    e.setHidden(true);
                } else if (this.plugin.getIPPattern().getReplace() != null) {
                    e.getMessage().setRawMessage(ipMatcher.replaceAll(this.plugin.getIPPattern().getReplace()));
                }
                this.plugin.increaseCounter(p, this.plugin.getIPPattern(), e.getMessage(), ipMatcher);
            }
        }
        if (this.rate > 0.0f) {
            UUID uuid = p.getUniqueId();
            Cache senderCache = this.msgHistory.get(uuid);
            if (this.denyRepeat && senderCache != null && senderCache.size() > 0L && senderCache.getIfPresent((Object)e.getMessage().getRawMessage().toLowerCase()) != null) {
                e.setHidden(true);
            }
            if (!e.isCancelled()) {
                if (senderCache == null) {
                    senderCache = CacheBuilder.newBuilder().expireAfterWrite((long)this.ttl, TimeUnit.SECONDS).build();
                    this.msgHistory.put(uuid, (Cache<String, Message>)senderCache);
                }
                senderCache.put((Object)e.getMessage().getRawMessage().toLowerCase(), (Object)e.getMessage());
                if ((float)senderCache.size() / (float)this.ttl > this.rate) {
                    this.plugin.increaseCounter(p, this.spamPattern, e.getMessage(), null);
                }
            }
        }
    }

    private boolean serverAlive(String host, int port) {
        try {
            if (!(host.startsWith("127.") || host.startsWith("0.") || host.startsWith("10.") || host.startsWith("192.168.") || host.startsWith("172."))) {
                InetSocketAddress sockaddr = new InetSocketAddress(host, port);
                Socket s = new Socket();
                s.connect(sockaddr, 250);
                s.close();
                this.plugin.log(Level.INFO, "[Autoban] Host " + host + ":" + port + " is reachable.");
                return true;
            }
        }
        catch (IOException e) {
            this.plugin.log(Level.INFO, "[Autoban] Host " + host + ":" + port + " is NOT reachable.");
        }
        return false;
    }

    private static String getHost(String msg) {
        Matcher matcher = IPPattern.matcher(msg);
        matcher.find();
        return matcher.group(1);
    }

    private static int getPort(String msg) {
        Matcher matcher = IPPattern.matcher(msg);
        matcher.find();
        if (matcher.group(2) == null || matcher.group(2).length() == 0) {
            return 25565;
        }
        int port = Integer.parseInt(matcher.group(2).replaceAll(":", ""));
        if (port != 0) {
            return port;
        }
        return 25565;
    }
}

