/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban;

import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.zaiyers.Channels.lib.minedown.adventure.MineDown;
import net.zaiyers.Channels.lib.minedown.adventure.Replacer;
import net.zaiyers.ChannelsAutoban.ChannelsAutoban;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCommandSender;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCounter;
import org.slf4j.event.Level;

public class ChannelsAutobanAction {
    private final ChannelsAutoban plugin;
    private boolean kick = false;
    private List<String> playerServerCmds;
    private Map<String, Object> serverGroupCommands;
    private List<String> localCmds;
    private List<String> notes;
    private ChannelsAutobanCommandSender sender;

    public ChannelsAutobanAction(ChannelsAutoban plugin, Map<String, Object> cfg) {
        this.plugin = plugin;
        this.sender = new ChannelsAutobanCommandSender(plugin);
        if (cfg.get("kick") != null) {
            this.kick = (Boolean)cfg.get("kick");
        }
        if (cfg.get("note") != null) {
            this.notes = (List)cfg.get("note");
        }
        if (cfg.get("playerserver") != null) {
            this.playerServerCmds = (List)cfg.get("playerserver");
        }
        if (cfg.get("groups") != null) {
            this.serverGroupCommands = (Map)cfg.get("groups");
        }
        if (cfg.get("local") != null) {
            this.localCmds = (List)cfg.get("local");
        }
    }

    public void execute(Player p, ChannelsAutobanCounter counter) {
        if (this.notes != null) {
            for (String string : this.notes) {
                p.sendMessage(MineDown.parse((String)string, (String[])new String[]{"name", p.getUsername(), "reason", counter.getReason()}));
            }
        }
        if (this.playerServerCmds != null && this.plugin.getConnectorPlugin() != null && p.getCurrentServer().isPresent()) {
            String playerServer = ((ServerConnection)p.getCurrentServer().get()).getServerInfo().getName();
            for (String cmd : this.playerServerCmds) {
                cmd = Replacer.replaceIn((String)cmd, (String[])new String[]{"name", p.getUsername(), "reason", counter.getReason()});
                this.plugin.getConnectorPlugin().getBridge().runServerConsoleCommand(playerServer, cmd, new Consumer[0]);
            }
        }
        if (this.serverGroupCommands != null && this.plugin.getConnectorPlugin() != null) {
            for (String string : this.serverGroupCommands.keySet()) {
                for (String server : this.plugin.getServerGroup(string)) {
                    if (this.plugin.getProxy().getServer(server).isEmpty()) {
                        this.plugin.log(Level.WARN, "Unknown server: " + server);
                        continue;
                    }
                    for (String cmd : (List)this.serverGroupCommands.get(string)) {
                        cmd = Replacer.replaceIn((String)cmd, (String[])new String[]{"name", p.getUsername(), "reason", counter.getReason()});
                        this.plugin.getConnectorPlugin().getBridge().runServerConsoleCommand(server, cmd, new Consumer[0]);
                    }
                }
            }
        }
        if (this.localCmds != null) {
            for (String string : this.localCmds) {
                String string2 = Replacer.replaceIn((String)string, (String[])new String[]{"name", p.getUsername(), "reason", counter.getReason()});
                this.plugin.getProxy().getCommandManager().executeImmediatelyAsync((CommandSource)this.sender, string2);
            }
        }
        if (this.kick) {
            p.disconnect(MineDown.parse((String)(counter.getReason() + " (Autoban)"), (String[])new String[0]));
        }
    }
}

