/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import de.themoep.connectorplugin.velocity.VelocityConnectorPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.zaiyers.Channels.command.AbstractCommandExecutor;
import net.zaiyers.Channels.message.Message;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanAction;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCommand;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCounter;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanPattern;
import net.zaiyers.ChannelsAutoban.ChannelsMessageListener;
import net.zaiyers.ChannelsAutoban.FileConfiguration;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.spongepowered.configurate.serialize.SerializationException;

public class ChannelsAutoban {
    private final ProxyServer proxy;
    private final Logger logger;
    private final FileConfiguration config;
    private List<ChannelsAutobanPattern> patterns = new ArrayList<ChannelsAutobanPattern>();
    private Map<String, ChannelsAutobanCounter> counters = new HashMap<String, ChannelsAutobanCounter>();
    private Table<UUID, String, Integer> violations = HashBasedTable.create();
    private Map<String, ChannelsAutobanAction> actions = new HashMap<String, ChannelsAutobanAction>();
    private String commandSenderName;
    private Map<String, Object> serverGroups;
    private ChannelsAutobanPattern ippattern;
    private List<String> ipWhitelist = new ArrayList<String>();
    private VelocityConnectorPlugin connectorPlugin;

    @Inject
    public ChannelsAutoban(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        this.proxy = proxy;
        this.logger = logger;
        this.config = new FileConfiguration(this, dataFolder.resolve("config.yml"));
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        Optional connectorPlugin = this.getProxy().getPluginManager().getPlugin("connectorplugin");
        if (connectorPlugin.isPresent()) {
            this.connectorPlugin = (VelocityConnectorPlugin)((PluginContainer)connectorPlugin.get()).getInstance().get();
        }
        try {
            this.loadConfig();
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
        this.getProxy().getEventManager().register((Object)this, (Object)new ChannelsMessageListener(this));
        this.registerCommand(new ChannelsAutobanCommand(this));
    }

    private void registerCommand(AbstractCommandExecutor command) {
        this.getProxy().getCommandManager().register(this.getProxy().getCommandManager().metaBuilder(command.getName()).aliases(command.getAliases()).plugin((Object)this).build(), (Command)command);
    }

    void loadConfig() throws SerializationException {
        FileConfiguration cfg = this.getConfig();
        cfg.load();
        this.commandSenderName = cfg.getString("commandsender", "Autoban");
        this.serverGroups = cfg.getSection("servergroups");
        List patternCfgs = cfg.getRawConfig("patterns").getList(Map.class);
        for (Map patternCfg : patternCfgs) {
            try {
                this.patterns.add(new ChannelsAutobanPattern(patternCfg));
            }
            catch (IllegalArgumentException e) {
                this.log(Level.ERROR, "Pattern config is invalid! " + e.getMessage() + " " + String.valueOf(patternCfg));
            }
        }
        LinkedHashMap<String, Object> ipCheck = new LinkedHashMap<String, Object>(cfg.getSection("ipcheck"));
        try {
            this.ippattern = new ChannelsAutobanPattern(ipCheck);
        }
        catch (IllegalArgumentException e) {
            this.log(Level.ERROR, "IP Pattern config is invalid! " + e.getMessage() + " " + String.valueOf(ipCheck));
        }
        this.ipWhitelist = cfg.getStringList("ipcheck.whitelist");
        Map<String, Object> counterCfgs = cfg.getSection("counters");
        for (String counterName : counterCfgs.keySet()) {
            try {
                this.counters.put(counterName, new ChannelsAutobanCounter((Map)counterCfgs.get(counterName)));
            }
            catch (Exception e) {
                this.log(Level.WARN, "Could not load counter " + counterName + " due to invalid configuration. " + e.getMessage());
            }
        }
        Map<String, Object> actionCfgs = cfg.getSection("actions");
        for (String actionName : actionCfgs.keySet()) {
            try {
                this.actions.put(actionName, new ChannelsAutobanAction(this, (Map)actionCfgs.get(actionName)));
            }
            catch (Exception e) {
                this.log(Level.WARN, "Could not load action " + actionName + " due to invalid configuration. " + e.getMessage());
            }
        }
    }

    public List<ChannelsAutobanPattern> getPatterns() {
        return this.patterns;
    }

    public String getCommandSenderName() {
        return this.commandSenderName;
    }

    public void increaseCounter(Player p, ChannelsAutobanPattern pattern, Message msg, Matcher matcher) {
        if (pattern.getCounter() == null) {
            return;
        }
        UUID uuid = p.getUniqueId();
        if (!this.violations.contains((Object)uuid, (Object)pattern.getCounter())) {
            this.violations.put((Object)uuid, (Object)pattern.getCounter(), (Object)1);
        } else {
            this.violations.put((Object)uuid, (Object)pattern.getCounter(), (Object)((Integer)this.violations.get((Object)uuid, (Object)pattern.getCounter()) + 1));
        }
        ChannelsAutobanCounter counter = this.counters.get(pattern.getCounter());
        if (counter == null) {
            this.log(Level.WARN, "No counter named '" + pattern.getCounter() + "' defined.");
        } else {
            String matched = matcher == null ? pattern.getCounter() : (matcher.groupCount() > 0 ? matcher.group(1) : matcher.group());
            HoverEvent hover = HoverEvent.showText((Component)Component.text((String)msg.getRawMessage()));
            Component reasonNotify = ((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[Autoban] ").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)(p.getUsername() + ": ")))).color((TextColor)NamedTextColor.WHITE)).append((Component)Component.text((String)matched))).color((TextColor)NamedTextColor.WHITE)).hoverEvent((HoverEventSource)hover);
            Component counterNotify = ((TextComponent)((TextComponent)Component.text((String)"[Autoban] ").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)(p.getUsername() + "@" + pattern.getCounter() + ": " + String.valueOf(this.violations.get((Object)uuid, (Object)pattern.getCounter())) + "/" + counter.getMax())))).color((TextColor)NamedTextColor.WHITE);
            this.getProxy().getConsoleCommandSource().sendMessage(reasonNotify);
            this.getProxy().getConsoleCommandSource().sendMessage(counterNotify);
            for (Player notify : this.getProxy().getAllPlayers()) {
                if (!notify.hasPermission("autoban.notify")) continue;
                notify.sendMessage(reasonNotify);
                notify.sendMessage(counterNotify);
            }
            if ((Integer)this.violations.get((Object)uuid, (Object)pattern.getCounter()) >= counter.getMax()) {
                ChannelsAutobanAction action = this.actions.get(counter.getAction());
                if (action == null) {
                    this.log(Level.WARN, "No action named '" + counter.getAction() + "' defined.");
                } else {
                    action.execute(p, counter);
                    return;
                }
            }
            this.getProxy().getScheduler().buildTask((Object)this, () -> {
                if (this.violations.contains((Object)uuid, (Object)pattern.getCounter())) {
                    this.violations.put((Object)uuid, (Object)pattern.getCounter(), (Object)((Integer)this.violations.get((Object)uuid, (Object)pattern.getCounter()) - 1));
                    Component counterNotify1 = ((TextComponent)((TextComponent)Component.text((String)"[Autoban] ").color((TextColor)NamedTextColor.RED)).append((Component)Component.text((String)(p.getUsername() + "@" + pattern.getCounter() + ": " + String.valueOf(this.violations.get((Object)uuid, (Object)pattern.getCounter())) + "/" + counter.getMax())))).color((TextColor)NamedTextColor.WHITE);
                    this.getProxy().getConsoleCommandSource().sendMessage(counterNotify1);
                    for (Player notify : this.getProxy().getAllPlayers()) {
                        if (!notify.hasPermission("autoban.notify")) continue;
                        notify.sendMessage(counterNotify1);
                    }
                }
            }).delay((long)counter.getTTL(), TimeUnit.SECONDS);
        }
    }

    public List<String> getServerGroup(String group) {
        return (List)this.serverGroups.get(group);
    }

    public ChannelsAutobanPattern getIPPattern() {
        return this.ippattern;
    }

    public List<String> getIPWhitelist() {
        return this.ipWhitelist;
    }

    VelocityConnectorPlugin getConnectorPlugin() {
        return this.connectorPlugin;
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public void log(Level level, String message) {
        this.logger.atLevel(level).log(message);
    }

    public void log(Level level, String message, Throwable throwable) {
        this.logger.atLevel(level).setCause(throwable).log(message);
    }
}

