/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban.lib.bungeeplugin;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.zaiyers.ChannelsAutoban.lib.bungeeplugin.FileConfiguration;

public abstract class BungeePlugin
extends Plugin {
    private boolean enabled;
    private FileConfiguration descConfig;
    private FileConfiguration pluginConfig;

    public void onLoad() {
        try {
            this.descConfig = new FileConfiguration((Plugin)this, this.getResourceAsStream("bungee.yml") != null ? "bungee.yml" : "plugin.yml");
            BungeePlugin.removeFromConfig(this.descConfig.getConfiguration(), "name", "main", "version", "author", "depends", "softDepends", "description");
            this.checkInvalid(this.descConfig.getConfiguration(), "softdepends", "soft-depends", "depend");
            this.descConfig.saveConfig();
            this.pluginConfig = new FileConfiguration(this, new File(this.getDataFolder(), "config.yml"), this.getResourceAsStream("bungee-config.yml") != null ? "bungee-config.yml" : "config.yml");
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while loading plugin. Will not enable!", e);
            this.enabled = false;
        }
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public FileConfiguration getConfig() {
        return this.pluginConfig;
    }

    public FileConfiguration getDescriptionConfig() {
        return this.descConfig;
    }

    public static String translate(String message, String ... replacements) {
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        int i = 0;
        while (i + 1 < replacements.length) {
            message = message.replace("%" + replacements[i] + "%", replacements[i + 1]);
            i += 2;
        }
        return message;
    }

    public static void broadcast(String permission, String message, String ... replacements) {
        message = BungeePlugin.translate(message, replacements);
        for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
            if (permission != null && !player.hasPermission(permission)) continue;
            player.sendMessage(message);
        }
    }

    public static void removeFromConfig(Configuration config, String ... paths) {
        for (String path : paths) {
            config.set(path, null);
        }
    }

    private void checkInvalid(Configuration configuration, String ... invalid) {
        for (String s : invalid) {
            if (!configuration.contains(s)) continue;
            this.getLogger().log(Level.WARNING, "Plugin description config contains invalid property '" + s + "'!");
        }
    }
}

