/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban;

import java.util.List;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.config.Configuration;
import net.zaiyers.ChannelsAutoban.ChannelsAutoban;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCommandSender;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCounter;

public class ChannelsAutobanAction {
    private final ChannelsAutoban plugin;
    private boolean kick = false;
    private List<String> playerServerCmds;
    private Configuration serverGroupCommands;
    private List<String> localCmds;
    private List<String> notes;
    private ChannelsAutobanCommandSender sender;

    public ChannelsAutobanAction(ChannelsAutoban plugin, Configuration cfg) {
        this.plugin = plugin;
        this.sender = new ChannelsAutobanCommandSender(plugin);
        if (cfg.get("kick") != null) {
            this.kick = cfg.getBoolean("kick");
        }
        if (cfg.get("note") != null) {
            this.notes = cfg.getStringList("note");
        }
        if (cfg.get("playerserver") != null) {
            this.playerServerCmds = cfg.getStringList("playerserver");
        }
        if (cfg.get("groups") != null) {
            this.serverGroupCommands = cfg.getSection("groups");
        }
        if (cfg.get("local") != null) {
            this.localCmds = cfg.getStringList("local");
        }
    }

    public void execute(ProxiedPlayer p, ChannelsAutobanCounter counter) {
        if (this.notes != null) {
            for (String msg : this.notes) {
                msg = msg.replaceAll("%name%", p.getName()).replaceAll("%reason%", counter.getReason());
                p.sendMessage(TextComponent.fromLegacyText((String)ChatColor.translateAlternateColorCodes((char)'&', (String)msg)));
            }
        }
        if (this.playerServerCmds != null && this.plugin.getBungeeRpc() != null) {
            for (String cmd : this.playerServerCmds) {
                cmd = cmd.replaceAll("%name%", p.getName()).replaceAll("%reason%", counter.getReason());
                this.plugin.getBungeeRpc().sendToBukkit(p.getServer().getInfo(), ChannelsAutoban.getInstance().getCommandSenderName(), cmd);
            }
        }
        if (this.serverGroupCommands != null && this.plugin.getBungeeRpc() != null) {
            for (String group : this.serverGroupCommands.getKeys()) {
                for (String server : this.plugin.getServerGroup(group)) {
                    ServerInfo serverInfo = this.plugin.getProxy().getServerInfo(server);
                    if (serverInfo == null) {
                        this.plugin.getLogger().warning("Unknown server: " + server);
                        continue;
                    }
                    for (String cmd : this.serverGroupCommands.getStringList(group)) {
                        cmd = cmd.replaceAll("%name%", p.getName()).replaceAll("%reason%", counter.getReason());
                        this.plugin.getBungeeRpc().sendToBukkit(serverInfo, ChannelsAutoban.getInstance().getCommandSenderName(), cmd);
                    }
                }
            }
        }
        if (this.localCmds != null) {
            for (String cmd : this.localCmds) {
                cmd = cmd.replaceAll("%name%", p.getName()).replaceAll("%reason%", counter.getReason());
                this.plugin.getProxy().getPluginManager().dispatchCommand((CommandSender)this.sender, cmd);
            }
        }
        if (this.kick) {
            p.disconnect((BaseComponent)new TextComponent(counter.getReason() + " (Autoban)"));
        }
    }
}

