/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.ChannelsAutoban;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.zaiyers.BungeeRPC.BungeeRPC;
import net.zaiyers.Channels.message.Message;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanAction;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCommand;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanCounter;
import net.zaiyers.ChannelsAutoban.ChannelsAutobanPattern;
import net.zaiyers.ChannelsAutoban.ChannelsMessageListener;
import net.zaiyers.ChannelsAutoban.lib.bungeeplugin.BungeePlugin;
import net.zaiyers.ChannelsAutoban.lib.bungeeplugin.FileConfiguration;

public class ChannelsAutoban
extends BungeePlugin {
    private List<ChannelsAutobanPattern> patterns = new ArrayList<ChannelsAutobanPattern>();
    private Map<String, ChannelsAutobanCounter> counters = new HashMap<String, ChannelsAutobanCounter>();
    private Table<UUID, String, Integer> violations = HashBasedTable.create();
    private Map<String, ChannelsAutobanAction> actions = new HashMap<String, ChannelsAutobanAction>();
    private String commandSenderName;
    private Configuration serverGroups;
    private ChannelsAutobanPattern ippattern;
    private List<String> ipWhitelist = new ArrayList<String>();
    private BungeeRPC bungeeRpc;

    public void onEnable() {
        if (this.getProxy().getPluginManager().getPlugin("BungeeRPC") != null) {
            this.bungeeRpc = (BungeeRPC)this.getProxy().getPluginManager().getPlugin("BungeeRPC");
        }
        this.loadConfig();
        this.getProxy().getPluginManager().registerListener((Plugin)this, (Listener)new ChannelsMessageListener(this));
        this.getProxy().getPluginManager().registerCommand((Plugin)this, (Command)new ChannelsAutobanCommand(this));
    }

    void loadConfig() {
        FileConfiguration cfg = this.getConfig();
        this.commandSenderName = cfg.getString("commandsender", "Autoban");
        this.serverGroups = cfg.getSection("servergroups");
        ArrayList patternCfgs = (ArrayList)cfg.get("patterns");
        for (Object patternCfg : patternCfgs) {
            try {
                this.patterns.add(new ChannelsAutobanPattern((Map<String, Object>)patternCfg));
            }
            catch (IllegalArgumentException e) {
                this.getLogger().log(Level.SEVERE, "Pattern config is invalid! " + e.getMessage() + " " + patternCfg);
            }
        }
        LinkedHashMap<String, Object> ipCheck = new LinkedHashMap<String, Object>();
        for (Object key : cfg.getSection("ipcheck").getKeys()) {
            ipCheck.put((String)key, cfg.get("ipcheck." + (String)key));
        }
        try {
            this.ippattern = new ChannelsAutobanPattern(ipCheck);
        }
        catch (IllegalArgumentException e) {
            this.getLogger().log(Level.SEVERE, "IP Pattern config is invalid! " + e.getMessage() + " " + ipCheck);
        }
        this.ipWhitelist = cfg.getStringList("ipcheck.whitelist");
        Configuration counterCfgs = cfg.getSection("counters");
        for (String counterName : counterCfgs.getKeys()) {
            try {
                this.counters.put(counterName, new ChannelsAutobanCounter(counterCfgs.getSection(counterName)));
            }
            catch (NumberFormatException e) {
                this.getLogger().warning("Could not load counter " + counterName + " due to invalid numbers in configuration. " + e.getMessage());
            }
        }
        Configuration actionCfgs = cfg.getSection("actions");
        for (String actionName : actionCfgs.getKeys()) {
            this.actions.put(actionName, new ChannelsAutobanAction(this, actionCfgs.getSection(actionName)));
        }
    }

    public static ChannelsAutoban getInstance() {
        return (ChannelsAutoban)ProxyServer.getInstance().getPluginManager().getPlugin("ChannelsAutoban");
    }

    public List<ChannelsAutobanPattern> getPatterns() {
        return this.patterns;
    }

    public String getCommandSenderName() {
        return this.commandSenderName;
    }

    public void increaseCounter(ProxiedPlayer p, ChannelsAutobanPattern pattern, Message msg, Matcher matcher) {
        if (pattern.getCounter() == null) {
            return;
        }
        UUID uuid = p.getUniqueId();
        if (!this.violations.contains((Object)uuid, (Object)pattern.getCounter())) {
            this.violations.put((Object)uuid, (Object)pattern.getCounter(), (Object)1);
        } else {
            this.violations.put((Object)uuid, (Object)pattern.getCounter(), (Object)((Integer)this.violations.get((Object)uuid, (Object)pattern.getCounter()) + 1));
        }
        ChannelsAutobanCounter counter = this.counters.get(pattern.getCounter());
        if (counter == null) {
            this.getLogger().warning("No counter named '" + pattern.getCounter() + "' defined.");
        } else {
            String matched = matcher == null ? pattern.getCounter() : (matcher.groupCount() > 0 ? matcher.group(1) : matcher.group());
            HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(msg.getRawMessage()).create());
            BaseComponent[] reasonNotify = new ComponentBuilder("[Autoban] ").color(ChatColor.RED).append(p.getDisplayName() + ": ").color(ChatColor.WHITE).append(matched).color(ChatColor.WHITE).event(hover).create();
            BaseComponent[] counterNotify = TextComponent.fromLegacyText((String)(ChatColor.RED + "[Autoban] " + ChatColor.WHITE + p.getDisplayName() + "@" + pattern.getCounter() + ": " + this.violations.get((Object)uuid, (Object)pattern.getCounter()) + "/" + counter.getMax()));
            this.getProxy().getConsole().sendMessage(reasonNotify);
            this.getProxy().getConsole().sendMessage(counterNotify);
            for (ProxiedPlayer notify : this.getProxy().getPlayers()) {
                if (!notify.hasPermission("autoban.notify")) continue;
                notify.sendMessage(reasonNotify);
                notify.sendMessage(counterNotify);
            }
            if ((Integer)this.violations.get((Object)uuid, (Object)pattern.getCounter()) >= counter.getMax()) {
                ChannelsAutobanAction action = this.actions.get(counter.getAction());
                if (action == null) {
                    this.getLogger().warning("No action named '" + counter.getAction() + "' defined.");
                } else {
                    action.execute(p, counter);
                    return;
                }
            }
            this.getProxy().getScheduler().schedule((Plugin)this, () -> {
                if (this.violations.contains((Object)uuid, (Object)pattern.getCounter())) {
                    this.violations.put((Object)uuid, (Object)pattern.getCounter(), (Object)((Integer)this.violations.get((Object)uuid, (Object)pattern.getCounter()) - 1));
                    BaseComponent[] counterNotify1 = TextComponent.fromLegacyText((String)(ChatColor.RED + "[Autoban] " + ChatColor.WHITE + p.getDisplayName() + "@" + pattern.getCounter() + ": " + this.violations.get((Object)uuid, (Object)pattern.getCounter())));
                    this.getProxy().getConsole().sendMessage(counterNotify1);
                    for (ProxiedPlayer notify : this.getProxy().getPlayers()) {
                        if (!notify.hasPermission("autoban.notify")) continue;
                        notify.sendMessage(counterNotify1);
                    }
                }
            }, (long)counter.getTTL(), TimeUnit.SECONDS);
        }
    }

    public List<String> getServerGroup(String group) {
        return this.serverGroups.getStringList(group);
    }

    public ChannelsAutobanPattern getIPPattern() {
        return this.ippattern;
    }

    public List<String> getIPWhitelist() {
        return this.ipWhitelist;
    }

    BungeeRPC getBungeeRpc() {
        return this.bungeeRpc;
    }
}

