/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.message;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.player.PlayerSettings;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.regex.Matcher;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.lib.minedown.adventure.MineDown;
import net.zaiyers.Channels.lib.minedown.adventure.MineDownParser;
import net.zaiyers.Channels.message.AbstractMessage;

public class PrivateMessage
extends AbstractMessage {
    private Chatter sender;
    private Chatter receiver;

    public PrivateMessage(Chatter sender, Chatter receiver, String message) {
        this.sender = sender;
        this.receiver = receiver;
        this.rawMessage = Matcher.quoteReplacement(message);
    }

    @Override
    public void send(boolean hidden) {
        if (this.receiver != null && this.receiver.isAFK()) {
            if (this.receiver.getAFKMessage() != null) {
                Channels.notify((CommandSource)this.sender.getPlayer(), "channels.chatter.is-afk-with-msg", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.receiver.getName(), (Object)"msg", (Object)this.receiver.getAFKMessage()));
            } else {
                Channels.notify((CommandSource)this.sender.getPlayer(), "channels.chatter.is-afk", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.receiver.getName()));
            }
        } else if (this.receiver != null && this.receiver.isDND()) {
            if (this.receiver.getDNDMessage() != null) {
                Channels.notify((CommandSource)this.sender.getPlayer(), "channels.chatter.is-dnd-with-msg", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.receiver.getName(), (Object)"msg", (Object)this.receiver.getDNDMessage()));
            } else {
                Channels.notify((CommandSource)this.sender.getPlayer(), "channels.chatter.is-dnd", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.receiver.getName()));
            }
            if (!this.sender.hasPermission("channels.bypass.dnd")) {
                return;
            }
        }
        boolean bypassIgnore = this.sender.hasPermission("channels.bypass.ignore");
        if (this.receiver != null && this.receiver.getPlayer().getPlayerSettings().getChatMode() != PlayerSettings.ChatMode.SHOWN && !bypassIgnore) {
            Channels.notify((CommandSource)this.sender.getPlayer(), "Channels.chatter.hides-chat", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.receiver.getName()));
        }
        this.processMessage(SenderRole.SENDER);
        this.sender.sendMessage(this.sender, this);
        if (!hidden && (bypassIgnore || !this.receiver.getIgnores().contains(this.sender.getPlayer().getUniqueId().toString())) && this.receiver.canSeeChat()) {
            this.processMessage(SenderRole.RECEIVER);
            this.receiver.sendMessage(bypassIgnore ? null : this.sender, this);
            this.receiver.setLastPrivateSender(this.sender);
        }
    }

    private void processMessage(SenderRole role) {
        Date date = new Date(this.getTime());
        SimpleDateFormat dateFormat = Channels.getConfig().getDateFormat();
        SimpleDateFormat timeFormat = Channels.getConfig().getTimeFormat();
        String pmFormat = Channels.getConfig().getPrivateMessageFormat(role);
        MineDown messageMd = new MineDown(this.rawMessage).urlHoverText(Channels.getInstance().getLanguage().getTranslation("chat.hover.open-url"));
        if (!this.getChatter().hasPermission("channels.color")) {
            messageMd.disable(MineDownParser.Option.LEGACY_COLORS);
        }
        if (!this.getChatter().hasPermission("channels.minedown.advanced")) {
            messageMd.disable(MineDownParser.Option.ADVANCED_FORMATTING);
        }
        if (!this.getChatter().hasPermission("channels.minedown.simple")) {
            messageMd.disable(MineDownParser.Option.SIMPLE_FORMATTING);
        }
        this.processedMessage = new MineDown(pmFormat).replace("sender", this.sender.getName(), "receiver", this.receiver.getName(), "date", dateFormat.format(date), "time", timeFormat.format(date)).replace("msg", messageMd.toComponent()).replace("sender-prefix", MineDown.parse(this.sender.getPrefix(), new String[0])).replace("sender-suffix", MineDown.parse(this.sender.getSuffix(), new String[0])).replace("receiver-prefix", MineDown.parse(this.receiver.getPrefix(), new String[0])).replace("receiver-suffix", MineDown.parse(this.receiver.getSuffix(), new String[0])).toComponent();
    }

    @Override
    public CommandSource getSender() {
        return this.sender.getPlayer();
    }

    public Chatter getChatter() {
        return this.sender;
    }

    public Chatter getReceiver() {
        return this.receiver;
    }

    public static enum SenderRole {
        SENDER,
        RECEIVER;

    }
}

