/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.listener;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Map;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;

public class ServerSwitchListener {
    @Subscribe
    public void onServerSwitch(ServerPostConnectEvent e) {
        if (e.getPlayer().getCurrentServer().isEmpty()) {
            return;
        }
        String serverName = ((ServerConnection)e.getPlayer().getCurrentServer().get()).getServerInfo().getName();
        if (Channels.getConfig().forceServerDefaultChannel(serverName)) {
            Channel channel = Channels.getInstance().getChannel(Channels.getConfig().getServerDefaultChannel(serverName));
            Chatter chatter = Channels.getInstance().getChatter(e.getPlayer());
            if (channel != null && !channel.getUUID().equals(chatter.getChannel())) {
                chatter.subscribe(channel);
                if (!chatter.hasPermission("channels.force-default-channel-bypass")) {
                    chatter.setDefaultChannelUUID(channel.getUUID());
                    Channels.notify((CommandSource)e.getPlayer(), "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
                } else {
                    Channels.notify((CommandSource)e.getPlayer(), "channels.chatter.default-channel-set-bypassed", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
                }
            } else {
                Channels.getInstance().getLogger().warning("Can not enforce default channel on server '" + serverName + "'. Channel does not exist.");
            }
        }
    }
}

