/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.listener;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.PostOrder;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.Map;
import java.util.Optional;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.PMCommand;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.ChannelMessage;
import net.zaiyers.Channels.message.PrivateMessage;

public class MessageListener {
    @Subscribe(order=PostOrder.LATE)
    public void onMessageRecieve(PlayerChatEvent event) {
        if (!event.getResult().isAllowed() || event.getMessage().startsWith("/")) {
            return;
        }
        boolean canceled = true;
        Player player = event.getPlayer();
        if (!event.getMessage().isEmpty() && event.getMessage().charAt(0) == '@') {
            String[] splittedMsg;
            if (event.getMessage().length() > 1) {
                splittedMsg = event.getMessage().split(" ");
                splittedMsg[0] = splittedMsg[0].substring(1);
            } else {
                splittedMsg = new String[]{};
            }
            PMCommand cmd = new PMCommand((CommandSource)player, splittedMsg);
            cmd.execute();
        } else {
            Chatter chatter = Channels.getInstance().getChatter(player);
            if (chatter.getLastRecipient() != null) {
                Chatter recipient = Channels.getInstance().getChatter(chatter.getLastRecipient());
                if (recipient == null) {
                    Channels.notify((CommandSource)player, "channels.chatter.recipient-offline", new String[0]);
                } else {
                    PrivateMessage msg = new PrivateMessage(chatter, recipient, event.getMessage());
                    ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
                    if (!Channels.getInstance().getProxy().getEventManager().fire((Object)chatEvent).isCancelled()) {
                        msg.send(chatEvent.isHidden());
                        if (!chatEvent.isHidden()) {
                            recipient.setLastPrivateSender(chatter);
                        }
                    }
                }
            } else {
                Channel chan = Channels.getInstance().getChannel(chatter.getChannel());
                Optional server = player.getCurrentServer();
                if (chatter.hasPermission(chan, "speak") && server.isPresent()) {
                    String serverName = ((ServerConnection)server.get()).getServerInfo().getName();
                    if (!chan.isGlobal() && !chan.getServers().contains(serverName)) {
                        String serverDefaultChannel = Channels.getConfig().getServerDefaultChannel(serverName);
                        chan = serverDefaultChannel != null ? Channels.getInstance().getChannel(serverDefaultChannel) : Channels.getInstance().getChannel(Channels.getConfig().getDefaultChannelUUID());
                        if (chan != null && chan.doAutojoin() && chatter.hasPermission(chan, "subscribe")) {
                            chatter.setDefaultChannelUUID(chan.getUUID());
                            chatter.subscribe(chan);
                            Channels.notify((CommandSource)chatter.getPlayer(), "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                        } else {
                            event.setResult(PlayerChatEvent.ChatResult.denied());
                            return;
                        }
                    }
                    ChannelMessage msg = new ChannelMessage(chatter, chan, event.getMessage());
                    ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
                    if (!Channels.getInstance().getProxy().getEventManager().fire((Object)chatEvent).isCancelled()) {
                        if (msg.getChannel().isBackend()) {
                            canceled = false;
                        } else {
                            msg.send(chatEvent.isHidden());
                        }
                    }
                } else {
                    Channels.notify((CommandSource)chatter.getPlayer(), "channels.permission.channel-no-speak", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                }
            }
        }
        if (canceled) {
            event.setResult(PlayerChatEvent.ChatResult.denied());
        }
    }
}

