/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.selector;

import java.util.List;
import net.zaiyers.Channels.lib.mongodb.ReadPreference;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterDescription;
import net.zaiyers.Channels.lib.mongodb.connection.ServerDescription;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterDescriptionHelper;
import net.zaiyers.Channels.lib.mongodb.selector.ServerSelector;

public class ReadPreferenceServerSelector
implements ServerSelector {
    private final ReadPreference readPreference;

    public ReadPreferenceServerSelector(ReadPreference readPreference) {
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return this.readPreference.choose(clusterDescription);
    }

    public String toString() {
        return "ReadPreferenceServerSelector{readPreference=" + this.readPreference + '}';
    }
}

