/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.event;

import java.util.List;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterSettings;
import net.zaiyers.Channels.lib.mongodb.connection.ConnectionPoolSettings;
import net.zaiyers.Channels.lib.mongodb.connection.ServerSettings;
import net.zaiyers.Channels.lib.mongodb.event.ClusterListener;
import net.zaiyers.Channels.lib.mongodb.event.CommandListener;
import net.zaiyers.Channels.lib.mongodb.event.ConnectionPoolListener;
import net.zaiyers.Channels.lib.mongodb.event.ServerListener;
import net.zaiyers.Channels.lib.mongodb.event.ServerMonitorListener;
import net.zaiyers.Channels.lib.mongodb.internal.event.ClusterListenerMulticaster;
import net.zaiyers.Channels.lib.mongodb.internal.event.CommandListenerMulticaster;
import net.zaiyers.Channels.lib.mongodb.internal.event.ConnectionPoolListenerMulticaster;
import net.zaiyers.Channels.lib.mongodb.internal.event.ServerListenerMulticaster;
import net.zaiyers.Channels.lib.mongodb.internal.event.ServerMonitorListenerMulticaster;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public final class EventListenerHelper {
    public static final ServerListener NO_OP_SERVER_LISTENER = new ServerListener(){};
    public static final ServerMonitorListener NO_OP_SERVER_MONITOR_LISTENER = new ServerMonitorListener(){};
    public static final ClusterListener NO_OP_CLUSTER_LISTENER = new ClusterListener(){};
    private static final ConnectionPoolListener NO_OP_CONNECTION_POOL_LISTENER = new ConnectionPoolListener(){};

    public static ClusterListener singleClusterListener(ClusterSettings clusterSettings) {
        Assertions.assertTrue(clusterSettings.getClusterListeners().size() <= 1);
        return clusterSettings.getClusterListeners().isEmpty() ? NO_OP_CLUSTER_LISTENER : clusterSettings.getClusterListeners().get(0);
    }

    public static ServerListener singleServerListener(ServerSettings serverSettings) {
        Assertions.assertTrue(serverSettings.getServerListeners().size() <= 1);
        return serverSettings.getServerListeners().isEmpty() ? NO_OP_SERVER_LISTENER : serverSettings.getServerListeners().get(0);
    }

    public static ServerMonitorListener singleServerMonitorListener(ServerSettings serverSettings) {
        Assertions.assertTrue(serverSettings.getServerMonitorListeners().size() <= 1);
        return serverSettings.getServerMonitorListeners().isEmpty() ? NO_OP_SERVER_MONITOR_LISTENER : serverSettings.getServerMonitorListeners().get(0);
    }

    public static ClusterListener clusterListenerMulticaster(List<ClusterListener> clusterListeners) {
        return new ClusterListenerMulticaster(clusterListeners);
    }

    public static ServerListener serverListenerMulticaster(List<ServerListener> serverListeners) {
        return new ServerListenerMulticaster(serverListeners);
    }

    public static ServerMonitorListener serverMonitorListenerMulticaster(List<ServerMonitorListener> serverMonitorListeners) {
        return new ServerMonitorListenerMulticaster(serverMonitorListeners);
    }

    @Nullable
    public static CommandListener getCommandListener(List<CommandListener> commandListeners) {
        switch (commandListeners.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return commandListeners.get(0);
            }
        }
        return new CommandListenerMulticaster(commandListeners);
    }

    public static ConnectionPoolListener getConnectionPoolListener(ConnectionPoolSettings connectionPoolSettings) {
        switch (connectionPoolSettings.getConnectionPoolListeners().size()) {
            case 0: {
                return NO_OP_CONNECTION_POOL_LISTENER;
            }
            case 1: {
                return connectionPoolSettings.getConnectionPoolListeners().get(0);
            }
        }
        return new ConnectionPoolListenerMulticaster(connectionPoolSettings.getConnectionPoolListeners());
    }

    private EventListenerHelper() {
    }
}

