/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.io.Closeable;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.ByteBuf;
import net.zaiyers.Channels.lib.bson.codecs.Decoder;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ReplyHeader;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ReplyMessage;

public class ResponseBuffers
implements Closeable {
    private final ReplyHeader replyHeader;
    private final ByteBuf bodyByteBuffer;
    private final int bodyByteBufferStartPosition;
    private volatile boolean isClosed;

    ResponseBuffers(ReplyHeader replyHeader, ByteBuf bodyByteBuffer) {
        this.replyHeader = replyHeader;
        this.bodyByteBuffer = bodyByteBuffer;
        this.bodyByteBufferStartPosition = bodyByteBuffer == null ? 0 : bodyByteBuffer.position();
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    <T extends BsonDocument> T getResponseDocument(int messageId, Decoder<T> decoder) {
        ReplyMessage<T> replyMessage = new ReplyMessage<T>(this, decoder, messageId);
        this.reset();
        return (T)((BsonDocument)replyMessage.getDocuments().get(0));
    }

    public ByteBuf getBodyByteBuffer() {
        return this.bodyByteBuffer.asReadOnly();
    }

    public void reset() {
        this.bodyByteBuffer.position(this.bodyByteBufferStartPosition);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            if (this.bodyByteBuffer != null) {
                this.bodyByteBuffer.release();
            }
            this.isClosed = true;
        }
    }
}

