/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.MongoInternalException;
import net.zaiyers.Channels.lib.mongodb.ServerAddress;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterId;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterType;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DnsSrvRecordInitializer;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DnsSrvRecordMonitor;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ServerAddressHelper;
import net.zaiyers.Channels.lib.mongodb.internal.diagnostics.logging.Logger;
import net.zaiyers.Channels.lib.mongodb.internal.diagnostics.logging.Loggers;
import net.zaiyers.Channels.lib.mongodb.internal.dns.DnsResolver;

class DefaultDnsSrvRecordMonitor
implements DnsSrvRecordMonitor {
    private static final Logger LOGGER = Loggers.getLogger("cluster");
    private final String hostName;
    private final String srvServiceName;
    private final long rescanFrequencyMillis;
    private final long noRecordsRescanFrequencyMillis;
    private final DnsSrvRecordInitializer dnsSrvRecordInitializer;
    private final DnsResolver dnsResolver;
    private final Thread monitorThread;
    private volatile boolean isClosed;

    DefaultDnsSrvRecordMonitor(String hostName, String srvServiceName, long rescanFrequencyMillis, long noRecordsRescanFrequencyMillis, DnsSrvRecordInitializer dnsSrvRecordInitializer, ClusterId clusterId, DnsResolver dnsResolver) {
        this.hostName = hostName;
        this.srvServiceName = srvServiceName;
        this.rescanFrequencyMillis = rescanFrequencyMillis;
        this.noRecordsRescanFrequencyMillis = noRecordsRescanFrequencyMillis;
        this.dnsSrvRecordInitializer = dnsSrvRecordInitializer;
        this.dnsResolver = dnsResolver;
        this.monitorThread = new Thread((Runnable)new DnsSrvRecordMonitorRunnable(), "cluster-" + clusterId + "-srv-" + hostName);
        this.monitorThread.setDaemon(true);
    }

    @Override
    public void start() {
        this.monitorThread.start();
    }

    @Override
    public void close() {
        this.isClosed = true;
        this.monitorThread.interrupt();
    }

    private class DnsSrvRecordMonitorRunnable
    implements Runnable {
        private Set<ServerAddress> currentHosts = Collections.emptySet();
        private ClusterType clusterType = ClusterType.UNKNOWN;

        private DnsSrvRecordMonitorRunnable() {
        }

        @Override
        public void run() {
            while (!DefaultDnsSrvRecordMonitor.this.isClosed && this.shouldContinueMonitoring()) {
                try {
                    List<String> resolvedHostNames = DefaultDnsSrvRecordMonitor.this.dnsResolver.resolveHostFromSrvRecords(DefaultDnsSrvRecordMonitor.this.hostName, DefaultDnsSrvRecordMonitor.this.srvServiceName);
                    Set<ServerAddress> hosts = this.createServerAddressSet(resolvedHostNames);
                    if (DefaultDnsSrvRecordMonitor.this.isClosed) {
                        return;
                    }
                    if (!hosts.equals(this.currentHosts)) {
                        try {
                            DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.initialize(Collections.unmodifiableSet(hosts));
                            this.currentHosts = hosts;
                        }
                        catch (Exception e) {
                            LOGGER.warn("Exception in monitor thread during notification of DNS resolution state change", e);
                        }
                    }
                }
                catch (MongoException e) {
                    if (this.currentHosts.isEmpty()) {
                        DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.initialize(e);
                    }
                    LOGGER.info("Exception while resolving SRV records", e);
                }
                catch (Exception e) {
                    if (this.currentHosts.isEmpty()) {
                        DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.initialize(new MongoInternalException("Unexpected runtime exception", e));
                    }
                    LOGGER.info("Unexpected runtime exception while resolving SRV record", e);
                }
                try {
                    Thread.sleep(this.getRescanFrequencyMillis());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.clusterType = DefaultDnsSrvRecordMonitor.this.dnsSrvRecordInitializer.getClusterType();
            }
        }

        private boolean shouldContinueMonitoring() {
            return this.clusterType == ClusterType.UNKNOWN || this.clusterType == ClusterType.SHARDED;
        }

        private long getRescanFrequencyMillis() {
            return this.currentHosts.isEmpty() ? DefaultDnsSrvRecordMonitor.this.noRecordsRescanFrequencyMillis : DefaultDnsSrvRecordMonitor.this.rescanFrequencyMillis;
        }

        private Set<ServerAddress> createServerAddressSet(List<String> resolvedHostNames) {
            HashSet<ServerAddress> hosts = new HashSet<ServerAddress>(resolvedHostNames.size());
            for (String host : resolvedHostNames) {
                hosts.add(ServerAddressHelper.createServerAddress(host));
            }
            return hosts;
        }
    }
}

