/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.FieldNameValidator;
import net.zaiyers.Channels.lib.bson.codecs.Decoder;
import net.zaiyers.Channels.lib.mongodb.MongoNamespace;
import net.zaiyers.Channels.lib.mongodb.ReadPreference;
import net.zaiyers.Channels.lib.mongodb.RequestContext;
import net.zaiyers.Channels.lib.mongodb.ServerApi;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.connection.CommandMessage;
import net.zaiyers.Channels.lib.mongodb.internal.connection.CommandProtocol;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalConnection;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ProtocolHelper;
import net.zaiyers.Channels.lib.mongodb.internal.connection.SplittablePayload;
import net.zaiyers.Channels.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

class CommandProtocolImpl<T>
implements CommandProtocol<T> {
    private final MongoNamespace namespace;
    private final BsonDocument command;
    private final SplittablePayload payload;
    private final ReadPreference readPreference;
    private final FieldNameValidator commandFieldNameValidator;
    private final FieldNameValidator payloadFieldNameValidator;
    private final Decoder<T> commandResultDecoder;
    private final boolean responseExpected;
    private final ClusterConnectionMode clusterConnectionMode;
    private final RequestContext requestContext;
    private SessionContext sessionContext;
    private final ServerApi serverApi;

    CommandProtocolImpl(String database, BsonDocument command, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi, RequestContext requestContext) {
        Assertions.notNull("database", database);
        this.namespace = new MongoNamespace(Assertions.notNull("database", database), "$cmd");
        this.command = Assertions.notNull("command", command);
        this.commandFieldNameValidator = Assertions.notNull("commandFieldNameValidator", commandFieldNameValidator);
        this.readPreference = readPreference;
        this.commandResultDecoder = Assertions.notNull("commandResultDecoder", commandResultDecoder);
        this.responseExpected = responseExpected;
        this.payload = payload;
        this.payloadFieldNameValidator = payloadFieldNameValidator;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
        this.requestContext = Assertions.notNull("requestContext", requestContext);
        Assertions.isTrueArgument("payloadFieldNameValidator cannot be null if there is a payload.", payload == null || payloadFieldNameValidator != null);
    }

    @Override
    @Nullable
    public T execute(InternalConnection connection) {
        return connection.sendAndReceive(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, this.requestContext);
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<T> callback) {
        try {
            connection.sendAndReceiveAsync(this.getCommandMessage(connection), this.commandResultDecoder, this.sessionContext, this.requestContext, (result, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(result, null);
                }
            });
        }
        catch (Throwable t2) {
            callback.onResult(null, t2);
        }
    }

    @Override
    public CommandProtocolImpl<T> sessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
        return this;
    }

    private CommandMessage getCommandMessage(InternalConnection connection) {
        return new CommandMessage(this.namespace, this.command, this.commandFieldNameValidator, this.readPreference, ProtocolHelper.getMessageSettings(connection.getDescription()), this.responseExpected, this.payload, this.payloadFieldNameValidator, this.clusterConnectionMode, this.serverApi);
    }
}

