/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.client.model;

import java.util.Iterator;
import net.zaiyers.Channels.lib.bson.BsonArray;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.mongodb.Function;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FieldSearchPath;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchPath;

public final class Util {
    public static final String SEARCH_PATH_VALUE_KEY = "value";

    public static BsonValue combineToBsonValue(Iterator<? extends SearchPath> nonEmptyPaths, boolean valueOnly) {
        Function<SearchPath, BsonValue> toBsonValueFunc = valueOnly ? path -> {
            if (path instanceof FieldSearchPath) {
                return new BsonString(((FieldSearchPath)path).toValue());
            }
            return path.toBsonValue();
        } : SearchPath::toBsonValue;
        BsonValue firstPath = toBsonValueFunc.apply(nonEmptyPaths.next());
        if (nonEmptyPaths.hasNext()) {
            BsonArray bsonArray = new BsonArray();
            bsonArray.add(firstPath);
            while (nonEmptyPaths.hasNext()) {
                bsonArray.add(toBsonValueFunc.apply(nonEmptyPaths.next()));
            }
            return bsonArray;
        }
        return firstPath;
    }

    public static boolean sizeAtLeast(Iterable<?> iterable, int minInclusive) {
        int size;
        Iterator<?> iter = iterable.iterator();
        for (size = 0; size < minInclusive && iter.hasNext(); ++size) {
            iter.next();
        }
        return size >= minInclusive;
    }

    private Util() {
        throw Assertions.fail();
    }
}

