/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.connection.netty;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class NettyByteBuf
implements net.zaiyers.Channels.lib.bson.ByteBuf {
    private ByteBuf proxied;
    private boolean isWriting = true;

    NettyByteBuf(ByteBuf proxied) {
        this.proxied = proxied.order(ByteOrder.LITTLE_ENDIAN);
    }

    NettyByteBuf(ByteBuf proxied, boolean isWriting) {
        this(proxied);
        this.isWriting = isWriting;
    }

    ByteBuf asByteBuf() {
        return this.proxied;
    }

    @Override
    public int capacity() {
        return this.proxied.capacity();
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf put(int index, byte b) {
        this.proxied.setByte(index, (int)b);
        return this;
    }

    @Override
    public int remaining() {
        if (this.isWriting) {
            return this.proxied.writableBytes();
        }
        return this.proxied.readableBytes();
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf put(byte[] src, int offset, int length) {
        this.proxied.writeBytes(src, offset, length);
        return this;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf put(byte b) {
        this.proxied.writeByte((int)b);
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf flip() {
        this.isWriting = !this.isWriting;
        return this;
    }

    @Override
    public byte[] array() {
        return this.proxied.array();
    }

    @Override
    public int limit() {
        if (this.isWriting) {
            return this.proxied.writerIndex() + this.remaining();
        }
        return this.proxied.readerIndex() + this.remaining();
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf position(int newPosition) {
        if (this.isWriting) {
            this.proxied.writerIndex(newPosition);
        } else {
            this.proxied.readerIndex(newPosition);
        }
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf clear() {
        this.proxied.clear();
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf order(ByteOrder byteOrder) {
        this.proxied = this.proxied.order(byteOrder);
        return this;
    }

    @Override
    public byte get() {
        return this.proxied.readByte();
    }

    @Override
    public byte get(int index) {
        return this.proxied.getByte(index);
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf get(byte[] bytes) {
        this.proxied.readBytes(bytes);
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf get(int index, byte[] bytes) {
        this.proxied.getBytes(index, bytes);
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf get(byte[] bytes, int offset, int length) {
        this.proxied.readBytes(bytes, offset, length);
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf get(int index, byte[] bytes, int offset, int length) {
        this.proxied.getBytes(index, bytes, offset, length);
        return this;
    }

    @Override
    public long getLong() {
        return this.proxied.readLong();
    }

    @Override
    public long getLong(int index) {
        return this.proxied.getLong(index);
    }

    @Override
    public double getDouble() {
        return this.proxied.readDouble();
    }

    @Override
    public double getDouble(int index) {
        return this.proxied.getDouble(index);
    }

    @Override
    public int getInt() {
        return this.proxied.readInt();
    }

    @Override
    public int getInt(int index) {
        return this.proxied.getInt(index);
    }

    @Override
    public int position() {
        if (this.isWriting) {
            return this.proxied.writerIndex();
        }
        return this.proxied.readerIndex();
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf limit(int newLimit) {
        if (this.isWriting) {
            throw new UnsupportedOperationException("Can not set the limit while writing");
        }
        this.proxied.writerIndex(newLimit);
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf asReadOnly() {
        return this;
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf duplicate() {
        return new NettyByteBuf(this.proxied.duplicate().retain(), this.isWriting);
    }

    @Override
    public ByteBuffer asNIO() {
        if (this.isWriting) {
            return this.proxied.nioBuffer(this.proxied.writerIndex(), this.proxied.writableBytes());
        }
        return this.proxied.nioBuffer(this.proxied.readerIndex(), this.proxied.readableBytes());
    }

    @Override
    public int getReferenceCount() {
        return this.proxied.refCnt();
    }

    @Override
    public net.zaiyers.Channels.lib.bson.ByteBuf retain() {
        this.proxied.retain();
        return this;
    }

    @Override
    public void release() {
        this.proxied.release();
    }
}

