/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.connection;

import java.util.Objects;
import net.zaiyers.Channels.lib.bson.types.ObjectId;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public final class ClusterId {
    private final String value;
    private final String description;

    public ClusterId() {
        this(null);
    }

    public ClusterId(@Nullable String description) {
        this.value = new ObjectId().toHexString();
        this.description = description;
    }

    ClusterId(String value, String description) {
        this.value = Assertions.notNull("value", value);
        this.description = description;
    }

    public String getValue() {
        return this.value;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterId clusterId = (ClusterId)o;
        if (!this.value.equals(clusterId.value)) {
            return false;
        }
        return Objects.equals(this.description, clusterId.description);
    }

    public int hashCode() {
        int result = this.value.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ClusterId{value='" + this.value + '\'' + ", description='" + this.description + '\'' + '}';
    }
}

