/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.search;

import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonDouble;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.bson.conversions.Bson;
import net.zaiyers.Channels.lib.mongodb.annotations.Beta;
import net.zaiyers.Channels.lib.mongodb.annotations.Evolving;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.search.ConstantSearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FieldSearchPath;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FunctionSearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.PathBoostSearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchConstructibleBsonElement;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchScoreExpression;
import net.zaiyers.Channels.lib.mongodb.client.model.search.ValueBoostSearchScore;

@Evolving
@Beta(value={Beta.Reason.CLIENT})
public interface SearchScore
extends Bson {
    public static ValueBoostSearchScore boost(float value) {
        return new SearchConstructibleBsonElement("boost", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static PathBoostSearchScore boost(FieldSearchPath path) {
        return new SearchConstructibleBsonElement("boost", (Bson)new Document("path", Assertions.notNull("value", path).toValue()));
    }

    public static ConstantSearchScore constant(float value) {
        return new SearchConstructibleBsonElement("constant", (Bson)new BsonDocument("value", new BsonDouble(value)));
    }

    public static FunctionSearchScore function(SearchScoreExpression expression) {
        return new SearchConstructibleBsonElement("function", (Bson)Assertions.notNull("expression", expression));
    }

    public static SearchScore of(Bson score) {
        return new SearchConstructibleBsonElement(Assertions.notNull("score", score));
    }
}

