/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.search;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.zaiyers.Channels.lib.bson.BsonInt32;
import net.zaiyers.Channels.lib.bson.conversions.Bson;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.search.AutocompleteSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.ConstantSearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.DateNearSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.DateSearchFacet;
import net.zaiyers.Channels.lib.mongodb.client.model.search.ExistsSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FacetSearchCollector;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FilterCompoundSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FunctionSearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.FuzzySearchOptions;
import net.zaiyers.Channels.lib.mongodb.client.model.search.GaussSearchScoreExpression;
import net.zaiyers.Channels.lib.mongodb.client.model.search.GeoNearSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.MustCompoundSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.MustNotCompoundSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.NumberNearSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.NumberSearchFacet;
import net.zaiyers.Channels.lib.mongodb.client.model.search.PathBoostSearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.PathSearchScoreExpression;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.SearchScore;
import net.zaiyers.Channels.lib.mongodb.client.model.search.ShouldCompoundSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.StringSearchFacet;
import net.zaiyers.Channels.lib.mongodb.client.model.search.TextSearchOperator;
import net.zaiyers.Channels.lib.mongodb.client.model.search.ValueBoostSearchScore;
import net.zaiyers.Channels.lib.mongodb.internal.client.model.AbstractConstructibleBsonElement;
import net.zaiyers.Channels.lib.mongodb.internal.client.model.Util;

final class SearchConstructibleBsonElement
extends AbstractConstructibleBsonElement<SearchConstructibleBsonElement>
implements MustCompoundSearchOperator,
MustNotCompoundSearchOperator,
ShouldCompoundSearchOperator,
FilterCompoundSearchOperator,
ExistsSearchOperator,
TextSearchOperator,
AutocompleteSearchOperator,
NumberNearSearchOperator,
DateNearSearchOperator,
GeoNearSearchOperator,
ValueBoostSearchScore,
PathBoostSearchScore,
ConstantSearchScore,
FunctionSearchScore,
GaussSearchScoreExpression,
PathSearchScoreExpression,
FacetSearchCollector,
StringSearchFacet,
NumberSearchFacet,
DateSearchFacet {
    SearchConstructibleBsonElement(String name) {
        super(name);
    }

    SearchConstructibleBsonElement(String name, Bson value) {
        super(name, value);
    }

    SearchConstructibleBsonElement(Bson baseElement) {
        super(baseElement);
    }

    private SearchConstructibleBsonElement(Bson baseElement, Bson appendedElementValue) {
        super(baseElement, appendedElementValue);
    }

    @Override
    protected SearchConstructibleBsonElement newSelf(Bson baseElement, Bson appendedElementValue) {
        return new SearchConstructibleBsonElement(baseElement, appendedElementValue);
    }

    @Override
    public StringSearchFacet numBuckets(int max) {
        return (StringSearchFacet)this.newWithAppendedValue("numBuckets", max);
    }

    @Override
    public SearchConstructibleBsonElement defaultBucket(String name) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("default", Assertions.notNull("name", name));
    }

    @Override
    public SearchConstructibleBsonElement fuzzy() {
        return this.fuzzy(FuzzySearchOptions.fuzzySearchOptions());
    }

    @Override
    public SearchConstructibleBsonElement fuzzy(FuzzySearchOptions options) {
        return (SearchConstructibleBsonElement)this.newWithMutatedValue(doc -> {
            doc.remove("synonyms");
            doc.append("fuzzy", Assertions.notNull("options", options));
        });
    }

    @Override
    public TextSearchOperator synonyms(String name) {
        return (TextSearchOperator)this.newWithMutatedValue(doc -> {
            doc.remove("fuzzy");
            doc.append("synonyms", Assertions.notNull("name", name));
        });
    }

    @Override
    public AutocompleteSearchOperator anyTokenOrder() {
        return (AutocompleteSearchOperator)this.newWithAppendedValue("tokenOrder", "any");
    }

    @Override
    public AutocompleteSearchOperator sequentialTokenOrder() {
        return (AutocompleteSearchOperator)this.newWithAppendedValue("tokenOrder", "sequential");
    }

    @Override
    public MustCompoundSearchOperator must(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("must", clauses);
    }

    @Override
    public MustNotCompoundSearchOperator mustNot(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("mustNot", clauses);
    }

    @Override
    public ShouldCompoundSearchOperator should(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("should", clauses);
    }

    @Override
    public FilterCompoundSearchOperator filter(Iterable<? extends SearchOperator> clauses) {
        return this.newCombined("filter", clauses);
    }

    private SearchConstructibleBsonElement newCombined(String ruleName, Iterable<? extends SearchOperator> clauses) {
        Assertions.notNull("clauses", clauses);
        Assertions.isTrueArgument("clauses must not be empty", Util.sizeAtLeast(clauses, 1));
        return (SearchConstructibleBsonElement)this.newWithMutatedValue(doc -> {
            Iterable existingClauses = (Iterable)((Object)doc.get((Object)ruleName, Iterable.class));
            Iterable newClauses = existingClauses == null ? clauses : (Iterable)Stream.concat(StreamSupport.stream(existingClauses.spliterator(), false), StreamSupport.stream(clauses.spliterator(), false)).collect(Collectors.toList());
            doc.append(ruleName, newClauses);
        });
    }

    @Override
    public ShouldCompoundSearchOperator minimumShouldMatch(int minimumShouldMatch) {
        return (ShouldCompoundSearchOperator)this.newWithAppendedValue("minimumShouldMatch", new BsonInt32(minimumShouldMatch));
    }

    @Override
    public SearchConstructibleBsonElement score(SearchScore modifier) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("score", Assertions.notNull("modifier", modifier));
    }

    @Override
    public SearchConstructibleBsonElement undefined(float fallback) {
        return (SearchConstructibleBsonElement)this.newWithAppendedValue("undefined", Float.valueOf(fallback));
    }

    @Override
    public GaussSearchScoreExpression offset(double offset) {
        return (GaussSearchScoreExpression)this.newWithAppendedValue("offset", offset);
    }

    @Override
    public GaussSearchScoreExpression decay(double decay) {
        return (GaussSearchScoreExpression)this.newWithAppendedValue("decay", decay);
    }
}

