/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.geojson.codecs;

import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.mongodb.client.model.geojson.Geometry;
import net.zaiyers.Channels.lib.mongodb.client.model.geojson.codecs.GeometryDecoderHelper;
import net.zaiyers.Channels.lib.mongodb.client.model.geojson.codecs.GeometryEncoderHelper;

abstract class AbstractGeometryCodec<T extends Geometry>
implements Codec<T> {
    private final CodecRegistry registry;
    private final Class<T> encoderClass;

    AbstractGeometryCodec(CodecRegistry registry, Class<T> encoderClass) {
        this.registry = registry;
        this.encoderClass = encoderClass;
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        GeometryEncoderHelper.encodeGeometry(writer, value, encoderContext, this.registry);
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return GeometryDecoderHelper.decodeGeometry(reader, this.getEncoderClass());
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.encoderClass;
    }
}

