/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.model.densify;

import java.time.Instant;
import java.util.Arrays;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonInt64;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.bson.conversions.Bson;
import net.zaiyers.Channels.lib.mongodb.annotations.Evolving;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.MongoTimeUnit;
import net.zaiyers.Channels.lib.mongodb.client.model.densify.DateDensifyRange;
import net.zaiyers.Channels.lib.mongodb.client.model.densify.DensifyConstructibleBson;
import net.zaiyers.Channels.lib.mongodb.client.model.densify.NumberDensifyRange;

@Evolving
public interface DensifyRange
extends Bson {
    public static NumberDensifyRange fullRangeWithStep(Number step) {
        return new DensifyConstructibleBson(new Document("bounds", "full").append("step", Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange partitionRangeWithStep(Number step) {
        return new DensifyConstructibleBson(new Document("bounds", "partition").append("step", Assertions.notNull("step", step)));
    }

    public static NumberDensifyRange rangeWithStep(Number l, Number u, Number step) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("step", step);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(l, u)).append("step", Assertions.notNull("step", step)));
    }

    public static DateDensifyRange fullRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("full")).append("step", new BsonInt64(step)).append("unit", new BsonString(unit.value())));
    }

    public static DateDensifyRange partitionRangeWithStep(long step, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new BsonDocument("bounds", new BsonString("partition")).append("step", new BsonInt64(step)).append("unit", new BsonString(unit.value())));
    }

    public static DateDensifyRange rangeWithStep(Instant l, Instant u, long step, MongoTimeUnit unit) {
        Assertions.notNull("l", l);
        Assertions.notNull("u", u);
        Assertions.notNull("unit", unit);
        return new DensifyConstructibleBson(new Document("bounds", Arrays.asList(l, u)).append("step", step).append("unit", unit.value()));
    }

    public static DensifyRange of(Bson range) {
        return new DensifyConstructibleBson(Assertions.notNull("range", range));
    }
}

