/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.client.internal;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.mongodb.ClientSessionOptions;
import net.zaiyers.Channels.lib.mongodb.MongoClientException;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.MongoInternalException;
import net.zaiyers.Channels.lib.mongodb.MongoQueryException;
import net.zaiyers.Channels.lib.mongodb.MongoSocketException;
import net.zaiyers.Channels.lib.mongodb.MongoTimeoutException;
import net.zaiyers.Channels.lib.mongodb.ReadConcern;
import net.zaiyers.Channels.lib.mongodb.ReadPreference;
import net.zaiyers.Channels.lib.mongodb.RequestContext;
import net.zaiyers.Channels.lib.mongodb.ServerApi;
import net.zaiyers.Channels.lib.mongodb.TransactionOptions;
import net.zaiyers.Channels.lib.mongodb.WriteConcern;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.ClientSession;
import net.zaiyers.Channels.lib.mongodb.client.SynchronousContextProvider;
import net.zaiyers.Channels.lib.mongodb.client.internal.ClientSessionBinding;
import net.zaiyers.Channels.lib.mongodb.client.internal.ClientSessionImpl;
import net.zaiyers.Channels.lib.mongodb.client.internal.Crypt;
import net.zaiyers.Channels.lib.mongodb.client.internal.CryptBinding;
import net.zaiyers.Channels.lib.mongodb.client.internal.OperationExecutor;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterDescription;
import net.zaiyers.Channels.lib.mongodb.connection.ServerDescription;
import net.zaiyers.Channels.lib.mongodb.internal.IgnorableRequestContext;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ClusterAwareReadWriteBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ClusterBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ReadWriteBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.WriteBinding;
import net.zaiyers.Channels.lib.mongodb.internal.connection.Cluster;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterDescriptionHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.ReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.WriteOperation;
import net.zaiyers.Channels.lib.mongodb.internal.session.ServerSessionPool;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

final class MongoClientDelegate {
    private final Cluster cluster;
    private final ServerSessionPool serverSessionPool;
    private final Object originator;
    private final OperationExecutor operationExecutor;
    private final Crypt crypt;
    @Nullable
    private final ServerApi serverApi;
    private final CodecRegistry codecRegistry;
    @Nullable
    private final SynchronousContextProvider contextProvider;
    private final AtomicBoolean closed;

    MongoClientDelegate(Cluster cluster, CodecRegistry codecRegistry, Object originator, @Nullable OperationExecutor operationExecutor, @Nullable Crypt crypt, @Nullable ServerApi serverApi, @Nullable SynchronousContextProvider contextProvider) {
        this.cluster = cluster;
        this.codecRegistry = codecRegistry;
        this.contextProvider = contextProvider;
        this.serverSessionPool = new ServerSessionPool(cluster, serverApi);
        this.originator = originator;
        this.operationExecutor = operationExecutor == null ? new DelegateOperationExecutor() : operationExecutor;
        this.crypt = crypt;
        this.serverApi = serverApi;
        this.closed = new AtomicBoolean();
    }

    public OperationExecutor getOperationExecutor() {
        return this.operationExecutor;
    }

    @Nullable
    public ClientSession createClientSession(ClientSessionOptions options, ReadConcern readConcern, WriteConcern writeConcern, ReadPreference readPreference) {
        Assertions.notNull("readConcern", readConcern);
        Assertions.notNull("writeConcern", writeConcern);
        Assertions.notNull("readPreference", readPreference);
        ClusterDescription connectedClusterDescription = this.getConnectedClusterDescription();
        if (connectedClusterDescription.getLogicalSessionTimeoutMinutes() == null && connectedClusterDescription.getConnectionMode() != ClusterConnectionMode.LOAD_BALANCED) {
            return null;
        }
        ClientSessionOptions mergedOptions = ClientSessionOptions.builder(options).defaultTransactionOptions(TransactionOptions.merge(options.getDefaultTransactionOptions(), TransactionOptions.builder().readConcern(readConcern).writeConcern(writeConcern).readPreference(readPreference).build())).build();
        return new ClientSessionImpl(this.serverSessionPool, this.originator, mergedOptions, this);
    }

    public void close() {
        if (!this.closed.getAndSet(true)) {
            if (this.crypt != null) {
                this.crypt.close();
            }
            this.serverSessionPool.close();
            this.cluster.close();
        }
    }

    public Cluster getCluster() {
        return this.cluster;
    }

    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    public ServerSessionPool getServerSessionPool() {
        return this.serverSessionPool;
    }

    private ClusterDescription getConnectedClusterDescription() {
        ClusterDescription clusterDescription = this.cluster.getDescription();
        if (this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription).isEmpty()) {
            this.cluster.selectServer(clusterDescription1 -> this.getServerDescriptionListToConsiderForSessionSupport(clusterDescription1));
            clusterDescription = this.cluster.getDescription();
        }
        return clusterDescription;
    }

    private List<ServerDescription> getServerDescriptionListToConsiderForSessionSupport(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return ClusterDescriptionHelper.getAnyPrimaryOrSecondary(clusterDescription);
    }

    private class DelegateOperationExecutor
    implements OperationExecutor {
        private DelegateOperationExecutor() {
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern) {
            return this.execute(operation, readPreference, readConcern, null);
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern) {
            return this.execute(operation, readConcern, null);
        }

        @Override
        public <T> T execute(ReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session) {
            if (session != null) {
                session.notifyOperationInitiated(operation);
            }
            ClientSession actualClientSession = this.getClientSession(session);
            ReadBinding binding = this.getReadBinding(readPreference, readConcern, actualClientSession, session == null && actualClientSession != null);
            try {
                if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                    throw new MongoClientException("Read preference in a transaction must be primary");
                }
                T t = operation.execute(binding);
                return t;
            }
            catch (MongoException e) {
                this.labelException(session, e);
                this.clearTransactionContextOnTransientTransactionError(session, e);
                throw e;
            }
            finally {
                binding.release();
            }
        }

        @Override
        public <T> T execute(WriteOperation<T> operation, ReadConcern readConcern, @Nullable ClientSession session) {
            if (session != null) {
                session.notifyOperationInitiated(operation);
            }
            ClientSession actualClientSession = this.getClientSession(session);
            WriteBinding binding = this.getWriteBinding(readConcern, actualClientSession, session == null && actualClientSession != null);
            try {
                T t = operation.execute(binding);
                return t;
            }
            catch (MongoException e) {
                this.labelException(session, e);
                this.clearTransactionContextOnTransientTransactionError(session, e);
                throw e;
            }
            finally {
                binding.release();
            }
        }

        WriteBinding getWriteBinding(ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(ReadPreference.primary(), readConcern, session, ownsSession);
        }

        ReadBinding getReadBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
            return this.getReadWriteBinding(readPreference, readConcern, session, ownsSession);
        }

        ReadWriteBinding getReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, @Nullable ClientSession session, boolean ownsSession) {
            ClusterAwareReadWriteBinding readWriteBinding = new ClusterBinding(MongoClientDelegate.this.cluster, this.getReadPreferenceForBinding(readPreference, session), readConcern, MongoClientDelegate.this.serverApi, this.getContext());
            if (MongoClientDelegate.this.crypt != null) {
                readWriteBinding = new CryptBinding(readWriteBinding, MongoClientDelegate.this.crypt);
            }
            if (session != null) {
                return new ClientSessionBinding(session, ownsSession, readWriteBinding);
            }
            return readWriteBinding;
        }

        private <T> RequestContext getContext() {
            RequestContext context = null;
            if (MongoClientDelegate.this.contextProvider != null) {
                context = MongoClientDelegate.this.contextProvider.getContext();
            }
            return context == null ? IgnorableRequestContext.INSTANCE : context;
        }

        private void labelException(@Nullable ClientSession session, MongoException e) {
            if (session != null && session.hasActiveTransaction() && (e instanceof MongoSocketException || e instanceof MongoTimeoutException || e instanceof MongoQueryException && e.getCode() == 91) && !e.hasErrorLabel("UnknownTransactionCommitResult")) {
                e.addLabel("TransientTransactionError");
            }
        }

        private void clearTransactionContextOnTransientTransactionError(@Nullable ClientSession session, MongoException e) {
            if (session != null && e.hasErrorLabel("TransientTransactionError")) {
                session.clearTransactionContext();
            }
        }

        private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
            if (session == null) {
                return readPreference;
            }
            if (session.hasActiveTransaction()) {
                ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
                if (readPreferenceForBinding == null) {
                    throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
                }
                return readPreferenceForBinding;
            }
            return readPreference;
        }

        @Nullable
        ClientSession getClientSession(@Nullable ClientSession clientSessionFromOperation) {
            ClientSession session;
            if (clientSessionFromOperation != null) {
                Assertions.isTrue("ClientSession from same MongoClient", clientSessionFromOperation.getOriginator() == MongoClientDelegate.this.originator);
                session = clientSessionFromOperation;
            } else {
                session = MongoClientDelegate.this.createClientSession(ClientSessionOptions.builder().causallyConsistent(false).build(), ReadConcern.DEFAULT, WriteConcern.ACKNOWLEDGED, ReadPreference.primary());
            }
            return session;
        }
    }
}

