/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.List;
import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonType;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.RepresentationConfigurable;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecConfigurationException;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.bson.codecs.pojo.ClassModel;
import net.zaiyers.Channels.lib.bson.codecs.pojo.DiscriminatorLookup;
import net.zaiyers.Channels.lib.bson.codecs.pojo.IdPropertyModelHolder;
import net.zaiyers.Channels.lib.bson.codecs.pojo.LazyMissingCodec;
import net.zaiyers.Channels.lib.bson.codecs.pojo.PojoCodec;
import net.zaiyers.Channels.lib.bson.codecs.pojo.PojoCodecImpl;
import net.zaiyers.Channels.lib.bson.codecs.pojo.PojoSpecializationHelper;
import net.zaiyers.Channels.lib.bson.codecs.pojo.PropertyCodecRegistry;
import net.zaiyers.Channels.lib.bson.codecs.pojo.PropertyModel;
import net.zaiyers.Channels.lib.bson.codecs.pojo.TypeData;
import net.zaiyers.Channels.lib.bson.codecs.pojo.TypeParameterMap;

class LazyPropertyModelCodec<T>
implements Codec<T> {
    private final PropertyModel<T> propertyModel;
    private final CodecRegistry registry;
    private final PropertyCodecRegistry propertyCodecRegistry;
    private final DiscriminatorLookup discriminatorLookup;
    private volatile Codec<T> codec;

    LazyPropertyModelCodec(PropertyModel<T> propertyModel, CodecRegistry registry, PropertyCodecRegistry propertyCodecRegistry, DiscriminatorLookup discriminatorLookup) {
        this.propertyModel = propertyModel;
        this.registry = registry;
        this.propertyCodecRegistry = propertyCodecRegistry;
        this.discriminatorLookup = discriminatorLookup;
    }

    @Override
    public T decode(BsonReader reader, DecoderContext decoderContext) {
        return this.getPropertyModelCodec().decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, T value, EncoderContext encoderContext) {
        this.getPropertyModelCodec().encode(writer, value, encoderContext);
    }

    @Override
    public Class<T> getEncoderClass() {
        return this.propertyModel.getTypeData().getType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Codec<T> getPropertyModelCodec() {
        if (this.codec == null) {
            LazyPropertyModelCodec lazyPropertyModelCodec = this;
            synchronized (lazyPropertyModelCodec) {
                if (this.codec == null) {
                    this.codec = this.createCodec();
                }
            }
        }
        return this.codec;
    }

    private Codec<T> createCodec() {
        Codec<T> localCodec = this.getCodecFromPropertyRegistry(this.propertyModel);
        if (localCodec instanceof PojoCodec) {
            PojoCodec pojoCodec = (PojoCodec)localCodec;
            ClassModel specialized = this.getSpecializedClassModel(pojoCodec.getClassModel(), this.propertyModel);
            localCodec = new PojoCodecImpl(specialized, this.registry, this.propertyCodecRegistry, pojoCodec.getDiscriminatorLookup(), true);
        }
        return localCodec;
    }

    private Codec<T> getCodecFromPropertyRegistry(PropertyModel<T> propertyModel) {
        BsonType representation;
        Codec<T> localCodec;
        try {
            localCodec = this.propertyCodecRegistry.get(propertyModel.getTypeData());
        }
        catch (CodecConfigurationException e) {
            return new LazyMissingCodec<T>(propertyModel.getTypeData().getType(), e);
        }
        if (localCodec == null) {
            localCodec = new LazyMissingCodec<T>(propertyModel.getTypeData().getType(), new CodecConfigurationException("Unexpected missing codec for: " + propertyModel.getName()));
        }
        if ((representation = propertyModel.getBsonRepresentation()) != null) {
            if (localCodec instanceof RepresentationConfigurable) {
                return ((RepresentationConfigurable)((Object)localCodec)).withRepresentation(representation);
            }
            throw new CodecConfigurationException("Codec must implement RepresentationConfigurable to support BsonRepresentation");
        }
        return localCodec;
    }

    private <V> ClassModel<T> getSpecializedClassModel(ClassModel<T> clazzModel, PropertyModel<V> propertyModel) {
        boolean changeTheDiscriminator;
        boolean useDiscriminator = propertyModel.useDiscriminator() == null ? clazzModel.useDiscriminator() : propertyModel.useDiscriminator().booleanValue();
        boolean validDiscriminator = clazzModel.getDiscriminatorKey() != null && clazzModel.getDiscriminator() != null;
        boolean bl = changeTheDiscriminator = useDiscriminator != clazzModel.useDiscriminator() && validDiscriminator;
        if (propertyModel.getTypeData().getTypeParameters().isEmpty() && !changeTheDiscriminator) {
            return clazzModel;
        }
        ArrayList concretePropertyModels = new ArrayList(clazzModel.getPropertyModels());
        PropertyModel<?> concreteIdProperty = clazzModel.getIdPropertyModel();
        List<TypeData<?>> propertyTypeParameters = propertyModel.getTypeData().getTypeParameters();
        for (int i = 0; i < concretePropertyModels.size(); ++i) {
            PropertyModel<?> model = concretePropertyModels.get(i);
            String propertyName = model.getName();
            TypeParameterMap typeParameterMap = clazzModel.getPropertyNameToTypeParameterMap().get(propertyName);
            if (!typeParameterMap.hasTypeParameters()) continue;
            PropertyModel<?> concretePropertyModel = this.getSpecializedPropertyModel(model, propertyTypeParameters, typeParameterMap);
            concretePropertyModels.set(i, concretePropertyModel);
            if (concreteIdProperty == null || !concreteIdProperty.getName().equals(propertyName)) continue;
            concreteIdProperty = concretePropertyModel;
        }
        boolean discriminatorEnabled = changeTheDiscriminator ? propertyModel.useDiscriminator().booleanValue() : clazzModel.useDiscriminator();
        return new ClassModel<T>(clazzModel.getType(), clazzModel.getPropertyNameToTypeParameterMap(), clazzModel.getInstanceCreatorFactory(), discriminatorEnabled, clazzModel.getDiscriminatorKey(), clazzModel.getDiscriminator(), IdPropertyModelHolder.create(clazzModel, concreteIdProperty), concretePropertyModels);
    }

    private <V> PropertyModel<V> getSpecializedPropertyModel(PropertyModel<V> propertyModel, List<TypeData<?>> propertyTypeParameters, TypeParameterMap typeParameterMap) {
        TypeData<V> specializedPropertyType = PojoSpecializationHelper.specializeTypeData(propertyModel.getTypeData(), propertyTypeParameters, typeParameterMap);
        if (propertyModel.getTypeData().equals(specializedPropertyType)) {
            return propertyModel;
        }
        return new PropertyModel<V>(propertyModel.getName(), propertyModel.getReadName(), propertyModel.getWriteName(), specializedPropertyType, null, propertyModel.getPropertySerialization(), propertyModel.useDiscriminator(), propertyModel.getPropertyAccessor(), propertyModel.getError(), propertyModel.getBsonRepresentation());
    }
}

