/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.bson.codecs.jsr310;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecConfigurationException;
import net.zaiyers.Channels.lib.bson.codecs.jsr310.DateTimeBasedCodec;

public class LocalDateCodec
extends DateTimeBasedCodec<LocalDate> {
    @Override
    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        return Instant.ofEpochMilli(this.validateAndReadDateTime(reader)).atZone(ZoneOffset.UTC).toLocalDate();
    }

    @Override
    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        try {
            writer.writeDateTime(value.atStartOfDay(ZoneOffset.UTC).toInstant().toEpochMilli());
        }
        catch (ArithmeticException e) {
            throw new CodecConfigurationException(String.format("Unsupported LocalDate '%s' could not be converted to milliseconds: %s", value, e.getMessage()), e);
        }
    }

    @Override
    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }
}

