/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.bson.codecs;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import net.zaiyers.Channels.lib.bson.BsonReader;
import net.zaiyers.Channels.lib.bson.BsonWriter;
import net.zaiyers.Channels.lib.bson.Transformer;
import net.zaiyers.Channels.lib.bson.UuidRepresentation;
import net.zaiyers.Channels.lib.bson.assertions.Assertions;
import net.zaiyers.Channels.lib.bson.codecs.AbstractMapCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonTypeClassMap;
import net.zaiyers.Channels.lib.bson.codecs.BsonTypeCodecMap;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.ContainerCodecHelper;
import net.zaiyers.Channels.lib.bson.codecs.DecoderContext;
import net.zaiyers.Channels.lib.bson.codecs.EncoderContext;
import net.zaiyers.Channels.lib.bson.codecs.OverridableUuidRepresentationCodec;
import net.zaiyers.Channels.lib.bson.codecs.Parameterizable;
import net.zaiyers.Channels.lib.bson.codecs.ParameterizedMapCodec;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecConfigurationException;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;

final class MapCodecV2<M extends Map<String, Object>>
extends AbstractMapCodec<Object, M>
implements OverridableUuidRepresentationCodec<M>,
Parameterizable {
    private final BsonTypeCodecMap bsonTypeCodecMap;
    private final CodecRegistry registry;
    private final Transformer valueTransformer;
    private final UuidRepresentation uuidRepresentation;

    MapCodecV2(CodecRegistry registry, BsonTypeClassMap bsonTypeClassMap, Transformer valueTransformer, Class<M> clazz) {
        this(registry, new BsonTypeCodecMap(Assertions.notNull("bsonTypeClassMap", bsonTypeClassMap), registry), valueTransformer, UuidRepresentation.UNSPECIFIED, clazz);
    }

    private MapCodecV2(CodecRegistry registry, BsonTypeCodecMap bsonTypeCodecMap, Transformer valueTransformer, UuidRepresentation uuidRepresentation, Class<M> clazz) {
        super(clazz);
        this.registry = Assertions.notNull("registry", registry);
        this.bsonTypeCodecMap = bsonTypeCodecMap;
        this.valueTransformer = valueTransformer != null ? valueTransformer : value -> value;
        this.uuidRepresentation = uuidRepresentation;
    }

    @Override
    public Codec<M> withUuidRepresentation(UuidRepresentation uuidRepresentation) {
        if (this.uuidRepresentation.equals((Object)uuidRepresentation)) {
            return this;
        }
        return new MapCodecV2(this.registry, this.bsonTypeCodecMap, this.valueTransformer, uuidRepresentation, this.getEncoderClass());
    }

    @Override
    public Codec<?> parameterize(CodecRegistry codecRegistry, List<Type> types) {
        if (types.size() != 2) {
            throw new CodecConfigurationException("Expected two parameterized type for an Iterable, but found " + types.size());
        }
        Type genericTypeOfMapKey = types.get(0);
        if (!genericTypeOfMapKey.getTypeName().equals("java.lang.String")) {
            throw new CodecConfigurationException("Unsupported key type for Map: " + genericTypeOfMapKey.getTypeName());
        }
        return new ParameterizedMapCodec(ContainerCodecHelper.getCodec(codecRegistry, types.get(1)), this.getEncoderClass());
    }

    @Override
    Object readValue(BsonReader reader, DecoderContext decoderContext) {
        return ContainerCodecHelper.readValue(reader, decoderContext, this.bsonTypeCodecMap, this.uuidRepresentation, this.registry, this.valueTransformer);
    }

    @Override
    void writeValue(BsonWriter writer, Object value, EncoderContext encoderContext) {
        Codec<?> codec = this.registry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }
}

