/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.Config;
import net.zaiyers.Channels.config.Configuration;

public abstract class YamlConfig
implements Config {
    protected Configuration cfg;
    private final Configuration defaultCfg;
    protected File configFile;

    public YamlConfig(File configFile) throws IOException {
        this.configFile = configFile;
        InputStream stream = Channels.getInstance().getResourceAsStream(configFile.getName());
        this.defaultCfg = stream != null ? new Configuration().load(new InputStreamReader(stream)) : null;
        this.load();
    }

    public void load() throws IOException {
        if (!this.configFile.exists()) {
            if (!this.configFile.getParentFile().exists()) {
                this.configFile.getParentFile().mkdirs();
            }
            this.configFile.createNewFile();
            this.cfg = new Configuration(this.defaultCfg).load(this.configFile);
            this.createDefaultConfig();
        } else {
            this.cfg = new Configuration(this.defaultCfg).load(this.configFile);
        }
    }

    @Override
    public void save() {
        try {
            this.cfg.save(this.configFile);
        }
        catch (IOException e) {
            Channels.getInstance().getLogger().severe("Unable to save configuration at " + this.configFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    @Override
    public void removeConfig() {
        this.configFile.delete();
    }
}

