/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.util.logging.Level;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.Configuration;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.mongodb.ConnectionString;
import net.zaiyers.Channels.lib.mongodb.MongoClientSettings;
import net.zaiyers.Channels.lib.mongodb.MongoCredential;
import net.zaiyers.Channels.lib.mongodb.MongoException;
import net.zaiyers.Channels.lib.mongodb.ServerApi;
import net.zaiyers.Channels.lib.mongodb.ServerApiVersion;
import net.zaiyers.Channels.lib.mongodb.client.MongoClient;
import net.zaiyers.Channels.lib.mongodb.client.MongoClients;
import net.zaiyers.Channels.lib.mongodb.client.MongoCollection;
import net.zaiyers.Channels.lib.mongodb.client.MongoDatabase;

public class MongoDBConnection {
    private MongoClient mongo;
    private MongoDatabase db;
    private MongoCollection<Document> channels;
    private MongoCollection<Document> chatters;

    public MongoDBConnection(Configuration cfg) {
        if (!this.mongoDBConnect(cfg) && this.mongo != null) {
            this.mongo.close();
            this.mongo = null;
        }
    }

    private boolean mongoDBConnect(Configuration cfg) {
        String mongoHost = cfg.getString("mongo.host", "localhost");
        int mongoPort = cfg.getInt("mongo.port", 27017);
        ServerApi serverApi = ServerApi.builder().version(ServerApiVersion.V1).build();
        MongoClientSettings.Builder settings = MongoClientSettings.builder().applyConnectionString(new ConnectionString("mongodb://" + mongoHost + ":" + mongoPort + "/")).serverApi(serverApi);
        if (cfg.getString("mongo.user") != null && !cfg.getString("mongo.pass").isEmpty()) {
            if (cfg.getString("mongo.authdb") == null || cfg.getString("mongo.pwd") == null || cfg.getString("mongo.authdb").isEmpty()) {
                throw new MongoException("Invalid configuration for mongoauth! To not use mongoauth leave the user empty!");
            }
            settings.credential(MongoCredential.createPlainCredential(cfg.getString("mongo.user"), cfg.getString("mongo.authdb"), cfg.getString("mongo.pass").toCharArray()));
        }
        try {
            this.mongo = MongoClients.create(settings.build());
            this.db = this.mongo.getDatabase(cfg.getString("mongo.db"));
            this.channels = this.db.getCollection(cfg.getString("mongo.channelCollection"));
            this.chatters = this.db.getCollection(cfg.getString("mongo.chatterCollection"));
        }
        catch (Exception e) {
            Channels.getInstance().getLogger().log(Level.SEVERE, "Error while connecting to Mongo DB", e);
            return false;
        }
        return true;
    }

    public boolean isAvailable() {
        return this.mongo != null;
    }

    public MongoCollection<Document> getChatters() {
        return this.chatters;
    }

    public MongoCollection<Document> getChannels() {
        return this.channels;
    }

    public MongoDatabase getDB() {
        return this.db;
    }
}

