/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.mongodb.client.MongoCollection;
import net.zaiyers.Channels.lib.mongodb.client.MongoCursor;
import net.zaiyers.Channels.lib.mongodb.client.model.Filters;
import org.yaml.snakeyaml.Yaml;

public class MongoConfiguration {
    private Document settings;

    public MongoConfiguration(MongoCollection<Document> col, String uuid) {
        if (uuid != null) {
            MongoCursor cursor = col.find(Filters.eq("uuid", uuid)).cursor();
            while (cursor.hasNext()) {
                this.settings = (Document)cursor.next();
            }
        }
    }

    public static void save(MongoCollection<Document> col, MongoConfiguration cfg) {
        Document config = new Document();
        config.putAll(cfg.settings);
        col.replaceOne(Filters.eq("uuid", cfg.settings.get("uuid")), config);
    }

    public List<String> getStringList(String path) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (Object object : this.getList(path)) {
            if (!(object instanceof String)) continue;
            stringList.add((String)object);
        }
        return stringList;
    }

    private List<Object> getList(String path) {
        if (this.settings.get(path) instanceof List) {
            return (List)this.settings.get(path);
        }
        if (this.settings.get(path) != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(this.settings.get(path));
            return list;
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        Object object = this.settings.get(key);
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return null;
    }

    public Boolean getBoolean(String key, boolean def) {
        Boolean b = this.getBoolean(key);
        return b != null ? b : def;
    }

    public String getString(String key) {
        Object object = this.settings.get(key);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public String getString(String key, String def) {
        String s = this.getString(key);
        return s != null ? s : def;
    }

    public void set(String key, Object value) {
        if (value instanceof ArrayList) {
            ArrayList save = new ArrayList();
            save.addAll((ArrayList)value);
            this.settings.put(key, (Object)save);
        } else {
            this.settings.put(key, value);
        }
    }

    public void load(InputStreamReader io) {
        Yaml yaml = new Yaml();
        this.settings = new Document();
        this.settings.putAll((Map)yaml.loadAs((Reader)io, LinkedHashMap.class));
    }

    public boolean loaded() {
        return this.settings != null;
    }
}

