/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.logging.Level;
import net.kyori.adventure.text.Component;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.Configuration;
import net.zaiyers.Channels.config.YamlConfig;
import net.zaiyers.Channels.lib.minedown.adventure.MineDown;
import org.spongepowered.configurate.ConfigurateException;

public class LanguageConfig
extends YamlConfig {
    public LanguageConfig(File configFile) throws IOException {
        super(configFile);
    }

    @Override
    public void createDefaultConfig() {
        InputStream defaultConfig = Channels.getInstance().getResourceAsStream(this.configFile.getName());
        if (defaultConfig == null) {
            defaultConfig = Channels.getInstance().getResourceAsStream("lang.en.yml");
        }
        this.cfg = new Configuration();
        try {
            this.cfg.load(new InputStreamReader(defaultConfig));
        }
        catch (ConfigurateException e) {
            Channels.getInstance().getLogger().log(Level.WARNING, "Unable to load default language configuration " + this.configFile.getName() + " from jar file!", e);
        }
        this.save();
    }

    public String getTranslation(String key) {
        if (this.cfg.getString(key, "").isEmpty()) {
            return "Unknown language key: " + key;
        }
        return this.cfg.getString(key);
    }

    public Component getTranslationComponent(String key, String ... replacements) {
        return new MineDown(this.getTranslation(key)).replace(replacements).toComponent();
    }

    public Component getTranslationComponent(String key, Map<String, String> replacements) {
        return new MineDown(this.getTranslation(key)).replace(replacements).replaceFirst(true).toComponent();
    }
}

