/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.ChatterConfig;
import net.zaiyers.Channels.config.Configuration;
import net.zaiyers.Channels.config.YamlConfig;
import org.spongepowered.configurate.ConfigurateException;

public class ChatterYamlConfig
extends YamlConfig
implements ChatterConfig {
    public ChatterYamlConfig(File configFile) throws IOException {
        super(configFile);
    }

    public static ChatterYamlConfig load(UUID uuid) {
        File cfgFile = new File(Channels.getInstance().getDataFolder(), ("chatters" + File.separator + uuid.toString().substring(0, 2) + File.separator + uuid.toString().substring(2, 4) + File.separator + String.valueOf(uuid) + ".yml").toLowerCase());
        if (cfgFile.exists()) {
            try {
                return new ChatterYamlConfig(cfgFile);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    @Override
    public List<String> getSubscriptions() {
        ArrayList<String> subs = new ArrayList<String>();
        for (String sub : this.cfg.getStringList("subscriptions")) {
            subs.add(sub);
        }
        return subs;
    }

    @Override
    public boolean isMuted() {
        return this.cfg.getBoolean("muted", false);
    }

    @Override
    public List<String> getIgnores() {
        return this.cfg.getStringList("ignores");
    }

    @Override
    public String getPrefix() {
        return this.cfg.getString("prefix", "");
    }

    @Override
    public String getSuffix() {
        return this.cfg.getString("suffix", "");
    }

    @Override
    public String getLastSender() {
        return this.cfg.getString("lastSender", null);
    }

    @Override
    public String getChannelUUID() {
        return this.cfg.getString("channelUUID");
    }

    @Override
    public void save() {
        try {
            this.cfg.save(this.configFile);
        }
        catch (IOException e) {
            Channels.getInstance().getLogger().severe("Unable to save chatter configuration '" + this.configFile.getAbsolutePath() + "'");
            e.printStackTrace();
        }
    }

    @Override
    public void createDefaultConfig() {
        this.cfg = new Configuration();
        try {
            this.cfg.load(new InputStreamReader(Channels.getInstance().getResourceAsStream("chatter.yml")));
        }
        catch (ConfigurateException e) {
            Channels.getInstance().getLogger().log(Level.SEVERE, "Unable to load default chatter configuration from jar", e);
        }
        this.cfg.set("channelUUID", Channels.getConfig().getDefaultChannelUUID().toString());
        ArrayList<String> subs = new ArrayList<String>();
        subs.add(Channels.getConfig().getDefaultChannelUUID());
        this.setSubscriptions(subs);
        this.save();
    }

    @Override
    public void setSubscriptions(List<String> subs) {
        ArrayList<String> subscriptions = new ArrayList<String>();
        for (String u : subs) {
            subscriptions.add(u.toString());
        }
        this.cfg.set("subscriptions", subscriptions);
    }

    @Override
    public void setMuted(boolean b) {
        this.cfg.set("muted", b);
    }

    @Override
    public void setPrefix(String prefix) {
        this.cfg.set("prefix", prefix);
    }

    @Override
    public void setSuffix(String suffix) {
        this.cfg.set("prefix", suffix);
    }

    @Override
    public void removeIgnore(String ignoreUUID) {
        List<String> ignores = this.cfg.getStringList("ignores");
        ignores.remove(ignoreUUID);
        this.cfg.set("ignores", ignores);
    }

    @Override
    public void addIgnore(String uuid) {
        List<String> ignores = this.cfg.getStringList("ignores");
        ignores.add(uuid);
        this.cfg.set("ignores", ignores);
    }

    @Override
    public void setDefaultChannel(String uuid) {
        this.cfg.set("channelUUID", uuid.toString());
    }

    @Override
    public void setLastSender(String uuid) {
        this.cfg.set("lastSender", uuid);
    }
}

