/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.ChannelMongoConfig;
import net.zaiyers.Channels.config.Configuration;
import net.zaiyers.Channels.config.MongoDBConnection;
import net.zaiyers.Channels.config.YamlConfig;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.mongodb.client.MongoCursor;
import net.zaiyers.Channels.message.PrivateMessage;
import org.spongepowered.configurate.ConfigurateException;

public class ChannelsConfig
extends YamlConfig {
    private MongoDBConnection mongo;

    public ChannelsConfig(File configFile) throws IOException {
        super(configFile);
        if (this.cfg.getBoolean("mongo.use")) {
            this.mongo = new MongoDBConnection(this.cfg);
            if (!this.mongo.isAvailable()) {
                throw new IOException("Unable to connect to Mongo DB even though it was enabled?");
            }
        }
    }

    public List<String> getChannels() {
        ArrayList<String> chans = new ArrayList<String>();
        File channelConfigDir = new File(this.configFile.getParentFile(), "channels");
        if (!channelConfigDir.exists()) {
            channelConfigDir.mkdirs();
            if (this.mongo != null && this.mongo.isAvailable()) {
                MongoCursor cursor = this.mongo.getChannels().find().cursor();
                if (!cursor.hasNext()) {
                    this.makeDefaultChannel();
                } else {
                    while (cursor.hasNext()) {
                        Document channelConfig = (Document)cursor.next();
                        String uuid = (String)channelConfig.get("uuid");
                        try {
                            ChannelMongoConfig cfg = new ChannelMongoConfig(Channels.getConfig().getMongoDBConnection().getChannels(), uuid);
                            Channel channel = new Channel(uuid);
                            channel.setAutofocus(cfg.doAutofocus());
                            channel.setAutojoin(cfg.doAutojoin());
                            channel.setColor(cfg.getColor());
                            channel.setBackend(cfg.isBackend());
                            channel.setName(cfg.getName());
                            channel.setFormat(cfg.getFormat());
                            channel.setTag(cfg.getTag());
                            channel.setPassword(cfg.getPassword());
                            channel.setGlobal(cfg.isGlobal());
                            for (String server : cfg.getServers()) {
                                channel.addServer(server);
                            }
                            for (String moderator : cfg.getModerators()) {
                                channel.addModerator(moderator);
                            }
                            for (String ban : cfg.getBans()) {
                                channel.banChatter(UUID.fromString(ban));
                            }
                            channel.save();
                            Channels.getInstance().getLogger().info("Imported channel " + channel.getName() + " (" + uuid + ") from Mongo");
                        }
                        catch (IOException e) {
                            Channels.getInstance().getLogger().log(Level.SEVERE, "Error while trying to import channel " + uuid, e);
                        }
                        chans.add((String)channelConfig.get("uuid"));
                    }
                }
            } else {
                this.makeDefaultChannel();
            }
        }
        for (File channelConfigFile : channelConfigDir.listFiles()) {
            if (!channelConfigFile.getName().endsWith(".yml")) continue;
            chans.add(channelConfigFile.getName().substring(0, 36));
        }
        return chans;
    }

    @Override
    public void save() {
        try {
            this.cfg.save(this.configFile);
        }
        catch (IOException e) {
            Channels.getInstance().getLogger().warning("Unable to save configuration!");
            e.printStackTrace();
        }
    }

    public boolean shouldSendUuidsInMessages() {
        return this.cfg.getBoolean("sendUuidsInMessages");
    }

    public boolean shouldHideVanished() {
        return this.cfg.getBoolean("hideVanished");
    }

    public String getDefaultChannelUUID() {
        return this.cfg.getString("defaultChannelUUID");
    }

    public void setDefaultChannelId(int id) {
        this.cfg.set("defaultChannelUUID", id);
    }

    public String getPrivateMessageFormat(PrivateMessage.SenderRole role) {
        if (role.equals((Object)PrivateMessage.SenderRole.SENDER)) {
            return this.cfg.getString("privateMessageFormatSender", "[&bTo %prefix%&b%receiver%%suffix%:](&7%date% %time%) %msg%");
        }
        if (role.equals((Object)PrivateMessage.SenderRole.RECEIVER)) {
            return this.cfg.getString("privateMessageFormatReceiver", "[&dFrom %prefix%&d%sender%%suffix%:](&7%date% %time%) %msg%");
        }
        return null;
    }

    public String getTimeHoverFormat() {
        return this.cfg.getString("timeHoverFormat", "\u00a77%date% %time%");
    }

    public SimpleDateFormat getDateFormat() {
        return new SimpleDateFormat(this.cfg.getString("dateFormat", "yyyy-MM-dd"));
    }

    public SimpleDateFormat getTimeFormat() {
        return new SimpleDateFormat(this.cfg.getString("timeFormat", "HH:mm:ss"));
    }

    @Override
    public void createDefaultConfig() {
        this.cfg = new Configuration();
        try {
            this.cfg.load(new InputStreamReader(Channels.getInstance().getResourceAsStream("config.yml")));
        }
        catch (ConfigurateException e) {
            throw new RuntimeException(e);
        }
        this.cfg.set("defaultChannelUUID", UUID.randomUUID().toString());
        this.save();
    }

    public String getLanguage() {
        return this.cfg.getString("language");
    }

    public void setServerDefaultChannel(String serverName, String string, boolean force) {
        this.cfg.set("serverDefaultChannels." + serverName, string);
        List<String> serverList = this.cfg.getStringList("forceServerDefaultChannel");
        serverList.remove(serverName);
        if (force) {
            serverList.add(serverName);
        }
        this.cfg.set("forceServerDefaultChannel", serverList);
    }

    public String getServerDefaultChannel(String serverName) {
        return this.cfg.getString("serverDefaultChannels." + serverName);
    }

    public boolean forceServerDefaultChannel(String serverName) {
        List<String> serverList = this.cfg.getStringList("forceServerDefaultChannel");
        return serverList.contains(serverName);
    }

    public MongoDBConnection getMongoDBConnection() {
        if (this.mongo != null) {
            if (this.mongo.isAvailable()) {
                return this.mongo;
            }
            Channels.getInstance().getLogger().warning("We wanted to use a mongo connection but it wasn't available?");
        }
        return null;
    }

    private Channel makeDefaultChannel() {
        try {
            Channel def = new Channel(this.getDefaultChannelUUID());
            def.setName("default");
            def.setTag("D");
            def.save();
            return def;
        }
        catch (IOException e) {
            Channels.getInstance().getLogger().severe("Could not create default channel!");
            e.printStackTrace();
            return null;
        }
    }
}

