/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.config;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import net.kyori.adventure.text.format.TextColor;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.ChannelConfig;
import net.zaiyers.Channels.config.MongoConfig;
import net.zaiyers.Channels.config.MongoConfiguration;
import net.zaiyers.Channels.lib.bson.Document;
import net.zaiyers.Channels.lib.mongodb.client.MongoCollection;

public class ChannelMongoConfig
extends MongoConfig
implements ChannelConfig {
    public ChannelMongoConfig(MongoCollection<Document> col, String uuid) throws IOException {
        super(col, uuid);
    }

    @Override
    public String getName() {
        return this.cfg.getString("name");
    }

    @Override
    public String getTag() {
        return this.cfg.getString("tag");
    }

    @Override
    public String getFormat() {
        return this.cfg.getString("format");
    }

    @Override
    public TextColor getColor() {
        return Channels.parseTextColor(this.cfg.getString("color"));
    }

    @Override
    public String getPassword() {
        return this.cfg.getString("password", "");
    }

    @Override
    public List<String> getServers() {
        return this.cfg.getStringList("servers");
    }

    @Override
    public List<String> getModerators() {
        return this.cfg.getStringList("moderators");
    }

    @Override
    public List<String> getBans() {
        return this.cfg.getStringList("bans");
    }

    @Override
    public void setName(String name) {
        this.cfg.set("name", name);
    }

    @Override
    public void setTag(String tag) {
        this.cfg.set("tag", tag);
    }

    @Override
    public void setFormat(String format) {
        this.cfg.set("format", format);
    }

    @Override
    public void setPassword(String password) {
        if (password == null) {
            this.cfg.set("password", "");
        } else {
            this.cfg.set("password", password);
        }
    }

    @Override
    public String getUUID() {
        return this.cfg.getString("uuid");
    }

    @Override
    public void createDefaultConfig() {
        this.cfg = new MongoConfiguration(Channels.getConfig().getMongoDBConnection().getChannels(), null);
        this.cfg.load(new InputStreamReader(Channels.getInstance().getResourceAsStream("channel.yml")));
        this.cfg.set("uuid", this.uuid.toString());
        this.save();
    }

    @Override
    public void addServer(String servername) {
        List<String> servers = this.getServers();
        servers.add(servername);
        this.cfg.set("servers", servers);
    }

    @Override
    public void removeServer(String servername) {
        List<String> servers = this.getServers();
        servers.remove(servername);
        this.cfg.set("servers", servers);
    }

    @Override
    public void addModerator(String uuid) {
        List<String> moderators = this.getModerators();
        moderators.add(uuid);
        this.cfg.set("moderators", moderators);
    }

    @Override
    public void removeModerator(String modUUID) {
        List<String> moderators = this.getModerators();
        moderators.remove(modUUID);
        this.cfg.set("moderators", moderators);
    }

    @Override
    public void setAutojoin(boolean b) {
        this.cfg.set("autojoin", b);
    }

    @Override
    public boolean doAutojoin() {
        return this.cfg.getBoolean("autojoin", false);
    }

    @Override
    public void addBan(String chatterUUID) {
        List<String> bans = this.getBans();
        bans.add(chatterUUID);
        this.cfg.set("bans", bans);
    }

    @Override
    public void removeBan(String chatterUUID) {
        List<String> bans = this.getBans();
        bans.remove(chatterUUID);
        this.cfg.set("bans", bans);
    }

    @Override
    public void setColor(TextColor color) {
        this.cfg.set("color", color.toString());
    }

    @Override
    public void setGlobal(boolean global) {
        this.cfg.set("global", global);
    }

    @Override
    public boolean isGlobal() {
        return this.cfg.getBoolean("global", true);
    }

    @Override
    public void setBackend(boolean backend) {
        this.cfg.set("backend", backend);
    }

    @Override
    public boolean isBackend() {
        return this.cfg.getBoolean("backend", false);
    }

    @Override
    public void setAutofocus(boolean autofocus) {
        this.cfg.set("autofocus", autofocus);
    }

    @Override
    public boolean doAutofocus() {
        return this.cfg.getBoolean("autofocus", false);
    }
}

