/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.PrivateMessage;

public class PMCommand
extends AbstractCommand {
    public PMCommand(CommandSource sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        if (!(this.sender instanceof Player)) {
            Channels.notify(this.sender, "channels.command.is-player-command", new String[0]);
            return;
        }
        Chatter chatter = Channels.getInstance().getChatter((Player)this.sender);
        if (this.args.length == 0) {
            chatter.setPrivateRecipient(null);
            Channels.notify(this.sender, "channels.command.recipient-unset", new String[0]);
            return;
        }
        if (!this.args[0].matches("^[a-zA-Z0-9_]+$")) {
            Channels.notify(this.sender, "channels.command.chatter-not-found", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.args[0]));
            return;
        }
        Chatter recipient = Channels.getInstance().getChatterByName(this.args[0]);
        if (recipient == null || recipient.getPlayer() == null || !recipient.getPlayer().isActive() || this.args.length == 1 && Channels.getConfig().shouldHideVanished() && Channels.getVNPVelocity() != null && !Channels.getVNPVelocity().canSee((CommandSource)chatter.getPlayer(), recipient.getPlayer())) {
            Channels.notify(this.sender, "channels.command.chatter-not-found", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.args[0]));
        } else if (this.args.length == 1) {
            chatter.setPrivateRecipient(recipient.getPlayer().getUniqueId().toString());
            Channels.notify(this.sender, "channels.chatter.recipient-set", (Map<String, String>)ImmutableMap.of((Object)"recipient", (Object)recipient.getName()));
        } else if (this.args.length > 1) {
            PrivateMessage msg = new PrivateMessage(chatter, recipient, this.argsToMessage(this.args));
            ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
            if (!Channels.getInstance().getProxy().getEventManager().fire((Object)chatEvent).isCancelled()) {
                msg.send(chatEvent.isHidden());
                recipient.setLastPrivateSender(chatter);
            }
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }

    private String argsToMessage(String[] args) {
        Object message = args[1];
        for (int i = 2; i < args.length; ++i) {
            message = (String)message + " " + args[i];
        }
        return message;
    }
}

