/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.command.ChannelsCommand;

public class ChannelUnsubscribeCommand
extends AbstractCommand
implements ChannelsCommand {
    public ChannelUnsubscribeCommand(CommandSource sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        if (!(this.sender instanceof Player)) {
            Channels.notify(this.sender, "channels.command.is-player-command", new String[0]);
            return;
        }
        Chatter chatter = Channels.getInstance().getChatter(((Player)this.sender).getUniqueId());
        Channel chan = Channels.getInstance().getChannel(this.args[1]);
        if (chan == null) {
            Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
            return;
        }
        if (!chatter.getSubscriptions().contains(chan.getUUID())) {
            Channels.notify(this.sender, "channels.chatter.channel-not-subscribed", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
            return;
        }
        if (!chatter.hasPermission(chan, "unsubscribe")) {
            Channels.notify(this.sender, "channels.permission.unsubscribe-channel", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
            return;
        }
        chatter.unsubscribe(chan.getUUID());
        Channels.notify(this.sender, "channels.command.channel-unsubscribed", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
    }

    @Override
    public boolean validateInput() {
        return this.args.length > 1;
    }
}

