/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.config.ChatterYamlConfig;

public class ChannelUnmuteCommand
extends AbstractCommand {
    public ChannelUnmuteCommand(CommandSource sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        Optional player = Channels.getInstance().getProxy().getPlayer(this.args[1]);
        if (player.isEmpty()) {
            UUID chatterUUID = Channels.getPlayerId(this.args[1]);
            if (chatterUUID == null) {
                Channels.notify(this.sender, "channels.command.chatter-not-found", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)this.args[1]));
                return;
            }
            ChatterYamlConfig cfg = ChatterYamlConfig.load(chatterUUID);
            cfg.setMuted(false);
            cfg.save();
            Channels.notify(this.sender, "channels.command.chatter-unmuted", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)Channels.getPlayerName(chatterUUID)));
        } else {
            UUID chatterUUID = ((Player)player.get()).getUniqueId();
            Channels.getInstance().getChatter(chatterUUID).setMuted(false);
            Channels.notify(this.sender, "channels.command.chatter-unmuted", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)((Player)player.get()).getUsername()));
        }
    }

    @Override
    public boolean validateInput() {
        return this.args.length > 1;
    }
}

