/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommand;
import net.zaiyers.Channels.lib.minedown.adventure.MineDown;

public class ChannelListCommand
extends AbstractCommand {
    public ChannelListCommand(CommandSource sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        boolean isConsoleCommand = !(this.sender instanceof Player);
        Chatter chatter = null;
        if (!isConsoleCommand) {
            chatter = Channels.getInstance().getChatter(((Player)this.sender).getUniqueId());
        }
        if (this.args.length == 1 && this.args[0].equalsIgnoreCase("list")) {
            Channels.notify(this.sender, "channels.chatter.available-channels", new String[0]);
            for (Channel channel : Channels.getInstance().getChannels().values()) {
                boolean onThisServer;
                boolean bl = onThisServer = channel.isGlobal() || isConsoleCommand || channel.getServers().contains(((ServerConnection)chatter.getPlayer().getCurrentServer().get()).getServerInfo().getName());
                if (isConsoleCommand || (chatter.hasPermission(channel, "subscribe") || channel.isTemporary()) && onThisServer) {
                    this.sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)Component.text((String)" - ").append(Component.text((String)channel.getTag()).color(channel.getColor()))).append((Component)Component.text((String)" - "))).append(Component.text((String)channel.getName()).color(channel.getColor()))).append((Component)Component.text((String)(" (" + (channel.getPassword().isEmpty() ? "public" : "private") + ")"))));
                    continue;
                }
                if (!chatter.hasPermission(channel, "globalread")) continue;
                this.sender.sendMessage(((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)" - ").append(Component.text((String)channel.getTag()).color(channel.getColor()))).append((Component)Component.text((String)" - "))).append(Component.text((String)channel.getName()).color(channel.getColor()))).append((Component)Component.text((String)(" (" + (channel.getPassword().isEmpty() ? "public" : "private") + ")")))).append(Component.text((String)(" " + (onThisServer ? "" : "not") + " on this server")).color((TextColor)NamedTextColor.GRAY)));
            }
        } else if (this.args.length == 2 || this.args.length == 1 && this.args[0].equalsIgnoreCase("who") && !isConsoleCommand) {
            Channel channel = null;
            if (this.args.length == 2) {
                channel = Channels.getInstance().getChannel(this.args[1]);
            } else if (!isConsoleCommand && chatter.getChannel() != null) {
                channel = Channels.getInstance().getChannel(chatter.getChannel());
            } else {
                Channels.notify(this.sender, "channels.chatter.has-no-channel", new String[0]);
            }
            if (channel == null) {
                Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
                return;
            }
            if (isConsoleCommand || chatter.hasPermission(channel, "list") || channel.isTemporary() && channel.getSubscriberUUIDs().contains(chatter.getPlayer().getUniqueId())) {
                UUID[] uuids = channel.getSubscriberUUIDs().toArray(new UUID[0]);
                Channels.notify(this.sender, "channels.chatter.channel-list-chatters", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
                ArrayList<Chatter> chatters = new ArrayList<Chatter>();
                for (UUID uuid : uuids) {
                    Chatter subscriber = Channels.getInstance().getChatter(uuid);
                    if (subscriber.getPlayer() == null || !subscriber.getPlayer().isActive() || chatter != null && Channels.getConfig().shouldHideVanished() && Channels.getVNPVelocity() != null && !Channels.getVNPVelocity().canSee((CommandSource)chatter.getPlayer(), subscriber.getPlayer())) continue;
                    chatters.add(subscriber);
                }
                if (chatters.size() > 0) {
                    TextComponent chatterList = Component.empty();
                    for (int i = 0; i < chatters.size(); ++i) {
                        Chatter subscriber = (Chatter)chatters.get(i);
                        if (i > 0) {
                            chatterList.append(Component.text((String)", ").color((TextColor)NamedTextColor.WHITE));
                        }
                        chatterList.append(MineDown.parse(subscriber.getPrefix(), new String[0])).append(Component.text((String)subscriber.getName()).color((TextColor)NamedTextColor.WHITE)).append(MineDown.parse(subscriber.getSuffix(), new String[0]));
                        if (subscriber.isAFK()) {
                            chatterList.append(Component.text((String)"(AFK)").color((TextColor)NamedTextColor.GRAY));
                            if (subscriber.getAFKMessage() != null) {
                                chatterList.hoverEvent((HoverEventSource)HoverEvent.showText((ComponentLike)((TextComponent.Builder)Component.text().append(Component.text((String)"AFK: ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)subscriber.getAFKMessage()).decorate(TextDecoration.ITALIC))));
                            }
                        }
                        if (!subscriber.isDND()) continue;
                        chatterList.append(Component.text((String)"(DND)").color((TextColor)NamedTextColor.GRAY));
                        if (subscriber.getAFKMessage() == null) continue;
                        chatterList.hoverEvent((HoverEventSource)HoverEvent.showText((ComponentLike)((TextComponent.Builder)Component.text().append(Component.text((String)"DND: ").color((TextColor)NamedTextColor.GRAY))).append(Component.text((String)subscriber.getDNDMessage()).decorate(TextDecoration.ITALIC))));
                    }
                    this.sender.sendMessage((Component)chatterList);
                }
            } else {
                Channels.notify(this.sender, "channels.permission.list-channel", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)channel.getName(), (Object)"channelColor", (Object)channel.getColor().toString()));
            }
        }
    }

    @Override
    public boolean validateInput() {
        return true;
    }
}

