/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.command;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.command.AbstractCommand;

public class ChannelColorCommand
extends AbstractCommand {
    public ChannelColorCommand(CommandSource sender, String[] args) {
        super(sender, args);
    }

    @Override
    public void execute() {
        if (this.args.length == 1) {
            TextComponent colorlist = Component.empty();
            for (NamedTextColor color : NamedTextColor.NAMES.values()) {
                colorlist = colorlist.append(Component.text((String)(color.toString() + " ")).color((TextColor)color));
            }
            this.sender.sendMessage((Component)colorlist);
            return;
        }
        if (this.args.length < 3) {
            Channels.notify(this.sender, "channels.usage.ChannelColorCommand", new String[0]);
            return;
        }
        Channel chan = Channels.getInstance().getChannel(this.args[1]);
        if (chan == null) {
            Channels.notify(this.sender, "channels.command.channel-not-found", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.args[1]));
            return;
        }
        if (this.sender instanceof Player && !chan.isMod(((Player)this.sender).getUniqueId().toString()) && !this.sender.hasPermission("channels.setcolor.foreign")) {
            Channels.notify(this.sender, "channels.command.channel-no-permission", new String[0]);
            return;
        }
        try {
            TextColor color = Channels.parseTextColor(this.args[2]);
            if (color == null) {
                throw new IllegalArgumentException();
            }
            chan.setColor(color);
            Channels.notify(this.sender, "channels.command.channel-modified", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
        }
        catch (IllegalArgumentException e) {
            Channels.notify(this.sender, "channels.command.color-not-found", (Map<String, String>)ImmutableMap.of((Object)"color", (Object)this.args[2]));
        }
    }

    @Override
    public boolean validateInput() {
        return this.args.length > 0;
    }
}

