/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.player.PlayerSettings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.context.ContextSet;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.config.ChatterConfig;
import net.zaiyers.Channels.config.ChatterMongoConfig;
import net.zaiyers.Channels.config.ChatterYamlConfig;
import net.zaiyers.Channels.events.ChatterAfkEvent;
import net.zaiyers.Channels.events.ChatterDndEvent;
import net.zaiyers.Channels.message.Message;

public class Chatter {
    private Player player;
    private boolean afk = false;
    private String afkMessage = "";
    private boolean dnd = false;
    private String dndMessage = "";
    private ChatterConfig cfg;
    private String privateRecipient = null;

    public Chatter(Player player) throws IOException {
        this.player = player;
        String uuid = player.getUniqueId().toString();
        this.cfg = Channels.getConfig().getMongoDBConnection() != null && Channels.getConfig().getMongoDBConnection().isAvailable() ? new ChatterMongoConfig(Channels.getConfig().getMongoDBConnection().getChatters(), uuid) : new ChatterYamlConfig(new File(Channels.getInstance().getDataFolder(), ("chatters" + File.separator + uuid.substring(0, 2) + File.separator + uuid.substring(2, 4) + File.separator + uuid + ".yml").toLowerCase()));
    }

    public List<String> getSubscriptions() {
        List<String> subscriptions = this.cfg.getSubscriptions();
        if (subscriptions.size() == 0) {
            subscriptions.add(Channels.getConfig().getDefaultChannelUUID());
        }
        return subscriptions;
    }

    public void subscribe(Channel chan) {
        Channel currentChannel;
        List<String> subs = this.cfg.getSubscriptions();
        if (!subs.contains(chan.getUUID())) {
            subs.add(chan.getUUID());
            this.cfg.setSubscriptions(subs);
        }
        chan.subscribe(this);
        if (!(!chan.doAutofocus() || this.privateRecipient != null || chan.getUUID().equals(this.getChannel()) || (currentChannel = Channels.getInstance().getChannel(this.getChannel())) != null && currentChannel.doAutofocus())) {
            this.setDefaultChannelUUID(chan.getUUID());
            Channels.notify((CommandSource)this.player, "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
        }
    }

    public void unsubscribe(String uuid) {
        List<String> subs = this.cfg.getSubscriptions();
        subs.remove(uuid);
        this.cfg.setSubscriptions(subs);
        if (uuid.equals(this.getChannel())) {
            Channel chan = null;
            if (this.player != null && this.player.getCurrentServer().isPresent()) {
                chan = Channels.getInstance().getChannel(Channels.getConfig().getServerDefaultChannel(((ServerConnection)this.player.getCurrentServer().get()).getServerInfo().getName()));
            }
            if (chan == null) {
                for (String channelId : subs) {
                    chan = Channels.getInstance().getChannel(channelId);
                    if (chan.doAutojoin() && !chan.isTemporary() && this.hasPermission(chan, "speak")) break;
                    chan = null;
                }
            }
            if (chan != null && this.hasPermission(chan, "subscribe")) {
                this.setDefaultChannelUUID(chan.getUUID());
                this.subscribe(chan);
                if (this.getLastRecipient() == null) {
                    Channels.notify((CommandSource)this.getPlayer(), "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                }
            }
        }
        if (Channels.getInstance().getChannel(uuid) != null) {
            Channels.getInstance().getChannel(uuid).unsubscribe(this);
        }
    }

    public boolean isMuted() {
        return this.cfg.isMuted();
    }

    public List<String> getIgnores() {
        return this.cfg.getIgnores();
    }

    public String getPrefix() {
        CachedMetaData metaData;
        if ((this.cfg.getPrefix() == null || this.cfg.getPrefix().isEmpty()) && Channels.getLuckPermsApi() != null && (metaData = this.getMetaData()) != null && metaData.getPrefix() != null) {
            return metaData.getPrefix();
        }
        return this.cfg.getPrefix();
    }

    public String getSuffix() {
        CachedMetaData metaData;
        if ((this.cfg.getSuffix() == null || this.cfg.getSuffix().isEmpty()) && Channels.getLuckPermsApi() != null && (metaData = this.getMetaData()) != null && metaData.getSuffix() != null) {
            return metaData.getSuffix();
        }
        return this.cfg.getSuffix();
    }

    private CachedMetaData getMetaData() {
        ContextSet contexts;
        User lpUser = Channels.getLuckPermsApi().getUserManager().getUser(this.player.getUniqueId());
        if (lpUser != null && (contexts = (ContextSet)Channels.getLuckPermsApi().getContextManager().getContext(lpUser).orElse(null)) != null) {
            return lpUser.getCachedData().getMetaData(QueryOptions.contextual((ContextSet)contexts));
        }
        return null;
    }

    public String getLastSender() {
        return this.cfg.getLastSender();
    }

    public String getLastRecipient() {
        return this.privateRecipient;
    }

    public String getChannel() {
        String channelUUID = this.cfg.getChannelUUID();
        if (Channels.getInstance().getChannel(channelUUID) == null) {
            channelUUID = Channels.getConfig().getDefaultChannelUUID();
        }
        return channelUUID;
    }

    public String getName() {
        return this.player.getUsername();
    }

    public boolean hasPermission(Channel channel, String permission) {
        return channel != null && this.player.hasPermission("channels." + permission + "." + channel.getTag());
    }

    public boolean hasPermission(String permission) {
        return this.player.hasPermission(permission);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void save() {
        this.cfg.save();
    }

    public void sendMessage(Chatter sender, Message message) {
        this.player.sendMessage(message.getProcessedMessage());
    }

    public void setDefaultChannelUUID(String string) {
        this.cfg.setDefaultChannel(string);
    }

    public void setMuted(boolean b) {
        this.cfg.setMuted(b);
    }

    public void setPrefix(String prefix) {
        this.cfg.setPrefix(prefix);
    }

    public void setSuffix(String suffix) {
        this.cfg.setSuffix(suffix);
    }

    public void setPrivateRecipient(String recipientUUID) {
        this.privateRecipient = recipientUUID;
    }

    public void setLastPrivateSender(Chatter chatter) {
        this.cfg.setLastSender(chatter.getPlayer().getUniqueId().toString());
    }

    public boolean isAFK() {
        return this.afk;
    }

    public void setAFK(boolean isAfk, String afkMessage) {
        ChatterAfkEvent event = new ChatterAfkEvent(this, isAfk, afkMessage);
        Channels.getInstance().getProxy().getEventManager().fire((Object)event);
        this.afk = isAfk;
        this.afkMessage = event.getMessage();
    }

    public boolean isDND() {
        return this.dnd;
    }

    public void setDND(boolean isDnd, String dndMsg) {
        ChatterDndEvent event = new ChatterDndEvent(this, isDnd, dndMsg);
        Channels.getInstance().getProxy().getEventManager().fire((Object)event);
        this.dnd = isDnd;
        this.dndMessage = event.getMessage();
    }

    public String getAFKMessage() {
        return this.afkMessage;
    }

    public String getDNDMessage() {
        return this.dndMessage;
    }

    public void sendMessage(String string) {
        this.player.sendMessage((Component)LegacyComponentSerializer.legacySection().deserialize(string));
    }

    public void sendMessage(Component textComponent) {
        this.player.sendMessage(textComponent);
    }

    public void removeIgnore(String ignoreUUID) {
        this.cfg.removeIgnore(ignoreUUID);
    }

    public void addIgnore(String uuid) {
        this.cfg.addIgnore(uuid);
    }

    public boolean canSeeChat() {
        PlayerSettings.ChatMode chatMode = this.player.getPlayerSettings().getChatMode();
        return chatMode == null || chatMode == PlayerSettings.ChatMode.SHOWN;
    }
}

