/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.velocitypowered.api.command.Command;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.annotation.DataDirectory;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import de.themoep.vnpvelocity.VNPVelocity;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.AbstractCommandExecutor;
import net.zaiyers.Channels.command.ChannelTagCommandExecutor;
import net.zaiyers.Channels.command.ChannelsCommandExecutor;
import net.zaiyers.Channels.config.ChannelsConfig;
import net.zaiyers.Channels.config.LanguageConfig;
import net.zaiyers.Channels.integration.MiniPlaceholdersIntegration;
import net.zaiyers.Channels.listener.MessageListener;
import net.zaiyers.Channels.listener.PlayerJoinListener;
import net.zaiyers.Channels.listener.PlayerQuitListener;
import net.zaiyers.Channels.listener.ServerSwitchListener;
import net.zaiyers.UUIDDB.core.UUIDDBPlugin;

@Plugin(id="channels")
public class Channels {
    private static Channels instance;
    private final ProxyServer proxy;
    private final Logger logger;
    private final Path dataFolder;
    private Map<UUID, Chatter> chatters = new HashMap<UUID, Chatter>();
    private static ChannelsConfig config;
    private static LanguageConfig lang;
    private Map<String, Channel> channels = new HashMap<String, Channel>();
    private Map<String, ChannelTagCommandExecutor> tagCommandExecutors = new HashMap<String, ChannelTagCommandExecutor>();
    private static LuckPerms luckPermsApi;
    private static UUIDDBPlugin uuidDb;
    private static VNPVelocity vnpVelocity;

    @Inject
    public Channels(ProxyServer proxy, Logger logger, @DataDirectory Path dataFolder) {
        this.proxy = proxy;
        this.logger = logger;
        this.dataFolder = dataFolder;
    }

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        instance = this;
        try {
            config = new ChannelsConfig(new File(this.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load configuration! Channels will not be enabled.");
            e.printStackTrace();
            return;
        }
        try {
            lang = new LanguageConfig(new File(this.getDataFolder(), "lang." + config.getLanguage() + ".yml"));
        }
        catch (IOException e) {
            this.getLogger().severe("Unable to load language! Channels will not be enabled.");
            e.printStackTrace();
            return;
        }
        if (this.getProxy().getPluginManager().getPlugin("vnpvelocity").isPresent()) {
            this.getLogger().info("Found VNPVelocity!");
            vnpVelocity = VNPVelocity.getInstance();
        }
        if (this.getProxy().getPluginManager().getPlugin("luckperms").isPresent()) {
            this.getLogger().info("Found LuckPerms!");
            luckPermsApi = LuckPermsProvider.get();
        }
        if (this.getProxy().getPluginManager().getPlugin("uuiddb").isPresent()) {
            this.getLogger().info("Found UUIDDB!");
            uuidDb = (UUIDDBPlugin)this.getProxy().getPluginManager().getPlugin("uuiddb").get();
        }
        if (this.getProxy().getPluginManager().getPlugin("miniplaceholders").isPresent()) {
            this.getLogger().info("Found MiniPlaceholders!");
            new MiniPlaceholdersIntegration();
        }
        if (Channels.getUuidDb() == null && Channels.getLuckPermsApi() == null) {
            this.getLogger().severe("You need either LuckPerms or UUIDDB installed for Channels to work! It will not be enabled.");
            return;
        }
        MessageListener ml = new MessageListener();
        PlayerJoinListener pjl = new PlayerJoinListener();
        PlayerQuitListener pql = new PlayerQuitListener();
        ServerSwitchListener swl = new ServerSwitchListener();
        this.getProxy().getEventManager().register((Object)this, (Object)ml);
        this.getProxy().getEventManager().register((Object)this, (Object)pjl);
        this.getProxy().getEventManager().register((Object)this, (Object)pql);
        this.getProxy().getEventManager().register((Object)this, (Object)swl);
        this.registerCommand(new ChannelsCommandExecutor("channel", new String[]{"ch", "channels"}));
        this.registerCommand(new ChannelsCommandExecutor("pm", new String[]{"tell", "msg"}));
        this.registerCommand(new ChannelsCommandExecutor("reply", "r"));
        this.registerCommand(new ChannelsCommandExecutor("afk", new String[0]));
        this.registerCommand(new ChannelsCommandExecutor("dnd", new String[0]));
        this.registerCommand(new ChannelsCommandExecutor("ignore", new String[0]));
        for (String channelUUID : config.getChannels()) {
            try {
                Channel channel = new Channel(channelUUID);
                this.channels.put(channel.getUUID(), channel);
                this.registerTag(channel.getTag());
            }
            catch (IOException e) {
                this.getLogger().severe("Couldn't load channel " + channelUUID);
                e.printStackTrace();
            }
        }
        this.checkSanity((CommandSource)this.getProxy().getConsoleCommandSource(), null);
    }

    private void registerCommand(AbstractCommandExecutor command) {
        this.getProxy().getCommandManager().register(this.getProxy().getCommandManager().metaBuilder(command.getName()).aliases(command.getAliases()).plugin((Object)this).build(), (Command)command);
    }

    public boolean reloadConfig() {
        try {
            lang.load();
        }
        catch (IOException e) {
            this.getLogger().severe("Error while loading the language config!");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void onDisable() {
        for (Channel channel : this.channels.values()) {
            channel.save();
        }
        for (Chatter chatter : this.chatters.values()) {
            chatter.save();
        }
        config.save();
    }

    public static ChannelsConfig getConfig() {
        return config;
    }

    public static Channels getInstance() {
        return instance;
    }

    public void removeChannel(String uuid) {
        Channel chan = this.channels.get(uuid);
        if (chan != null) {
            chan.removeChannel();
        }
        this.channels.remove(uuid);
    }

    public Chatter getChatter(Player player) {
        Chatter chatter = this.chatters.get(player.getUniqueId());
        if (chatter == null) {
            chatter = this.createChatter(player);
        }
        if (chatter == null) {
            this.getLogger().log(Level.WARNING, "Could not get the chatter for " + player.getUsername() + "/" + String.valueOf(player.getUniqueId()) + "?");
            return null;
        }
        this.chatters.put(player.getUniqueId(), chatter);
        return chatter;
    }

    public Chatter getChatter(String playerId) {
        return this.getChatter(UUID.fromString(playerId));
    }

    public Chatter getChatter(UUID playerId) {
        Chatter chatter = this.chatters.get(playerId);
        if (chatter != null) {
            return chatter;
        }
        Optional player = this.getProxy().getPlayer(playerId);
        if (player.isPresent()) {
            return this.getChatter((Player)player.get());
        }
        this.getLogger().log(Level.WARNING, "Could not create the chatter? The player with the uuid " + String.valueOf(playerId) + " wasn't found online?");
        return null;
    }

    public Chatter getChatterByName(String name) {
        Optional player = this.getProxy().getPlayer(name);
        if (player.isPresent()) {
            return this.getChatter((Player)player.get());
        }
        name = name.toLowerCase();
        for (Chatter onlinechatter : this.chatters.values()) {
            if (onlinechatter == null || !onlinechatter.getName().toLowerCase().startsWith(name)) continue;
            return onlinechatter;
        }
        return null;
    }

    public void addChannel(Channel channel) {
        this.channels.put(channel.getUUID(), channel);
    }

    public Channel getChannel(String string) {
        if (this.channels.containsKey(string)) {
            return this.channels.get(string);
        }
        for (Channel channel : this.channels.values()) {
            if (!channel.getTag().equalsIgnoreCase(string) && !channel.getName().equalsIgnoreCase(string)) continue;
            return channel;
        }
        return null;
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public void removeChatter(UUID playerId) {
        this.chatters.remove(playerId);
    }

    public static void notify(CommandSource sender, String key, String ... replacements) {
        sender.sendMessage(Channels.getInstance().getLanguage().getTranslationComponent(key, replacements));
    }

    public static void notify(CommandSource sender, String key, Map<String, String> replacements) {
        sender.sendMessage(Channels.getInstance().getLanguage().getTranslationComponent(key, replacements));
    }

    public LanguageConfig getLanguage() {
        return lang;
    }

    public void registerTag(String tag) {
        ChannelTagCommandExecutor executor = new ChannelTagCommandExecutor(tag.toLowerCase());
        this.registerCommand(executor);
        this.tagCommandExecutors.put(tag, executor);
    }

    public void unregisterTag(String tag) {
        if (this.tagCommandExecutors.containsKey(tag)) {
            this.getProxy().getCommandManager().unregister(this.tagCommandExecutors.get(tag).getName());
            this.tagCommandExecutors.remove(tag);
        }
    }

    public Map<UUID, Chatter> getChatters() {
        return this.chatters;
    }

    public void checkSanity(CommandSource sender, String channelId) {
        Channel chan = this.channels.get(channelId);
        Channel def = this.channels.get(config.getDefaultChannelUUID());
        if (chan != null && !chan.isGlobal() && chan.getServers().isEmpty()) {
            Channels.notify(sender, "channels.command.channel-has-no-servers", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
        }
        for (RegisteredServer registeredServer : this.getProxy().getAllServers()) {
            ServerInfo server = registeredServer.getServerInfo();
            Channel serverDef = this.channels.get(config.getServerDefaultChannel(server.getName()));
            if (serverDef != null) {
                if (!serverDef.isGlobal() && !serverDef.getServers().contains(server.getName())) {
                    Channels.notify(sender, "channels.command.default-channel-unavailable", (Map<String, String>)ImmutableMap.of((Object)"server", (Object)server.getName()));
                }
                if (serverDef.doAutojoin()) continue;
                Channels.notify(sender, "channels.command.default-channel-no-autojoin", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)serverDef.getName(), (Object)"channelColor", (Object)serverDef.getColor().toString()));
                continue;
            }
            if (def != null && (def.isGlobal() || def.getServers().contains(server.getName()))) continue;
            Channels.notify(sender, "channels.command.default-no-defchannel-available", (Map<String, String>)ImmutableMap.of((Object)"server", (Object)server.getName()));
        }
    }

    public static VNPVelocity getVNPVelocity() {
        return vnpVelocity;
    }

    public static LuckPerms getLuckPermsApi() {
        return luckPermsApi;
    }

    public static UUIDDBPlugin getUuidDb() {
        return uuidDb;
    }

    public static String getPlayerName(String playerId) {
        return Channels.getPlayerName(UUID.fromString(playerId));
    }

    public static String getPlayerName(UUID playerId) {
        User lpUser;
        String playerName = null;
        Optional player = Channels.getInstance().getProxy().getPlayer(playerId);
        if (player.isPresent()) {
            playerName = ((Player)player.get()).getUsername();
        }
        if (Channels.getUuidDb() != null) {
            playerName = Channels.getUuidDb().getStorage().getNameByUUID(playerId);
        }
        if (playerName == null && Channels.getLuckPermsApi() != null && (lpUser = Channels.getLuckPermsApi().getUserManager().getUser(playerId)) != null) {
            playerName = lpUser.getUsername();
        }
        return playerName != null ? playerName : "Unknown";
    }

    public static UUID getPlayerId(String name) {
        User lpUser;
        String idStr;
        UUID playerId = null;
        Optional player = Channels.getInstance().getProxy().getPlayer(name);
        if (player.isPresent()) {
            playerId = ((Player)player.get()).getUniqueId();
        }
        if (playerId == null && Channels.getUuidDb() != null && (idStr = Channels.getUuidDb().getStorage().getUUIDByName(name, false)) != null) {
            playerId = UUID.fromString(idStr);
        }
        if (playerId == null && Channels.getLuckPermsApi() != null && (lpUser = Channels.getLuckPermsApi().getUserManager().getUser(name)) != null) {
            playerId = lpUser.getUniqueId();
        }
        return playerId;
    }

    public static TextColor parseTextColor(String colorString) {
        TextColor color = TextColor.fromCSSHexString((String)colorString);
        if (color != null) {
            return color;
        }
        return (TextColor)NamedTextColor.NAMES.value((Object)colorString);
    }

    private Chatter createChatter(Player player) {
        try {
            Chatter chatter = new Chatter(player);
            for (String channelUUID : chatter.getSubscriptions()) {
                if (this.getChannel(channelUUID) != null) {
                    if (chatter.hasPermission(this.getChannel(channelUUID), "subscribe")) {
                        this.getChannel(channelUUID).subscribe(chatter);
                        continue;
                    }
                    chatter.unsubscribe(channelUUID);
                    if (!channelUUID.equals(Channels.getConfig().getDefaultChannelUUID())) continue;
                    this.getLogger().warning("Chatter '" + chatter.getName() + "' is not allowed to join the default channel");
                    continue;
                }
                chatter.unsubscribe(channelUUID);
            }
            for (Channel channel : Channels.getInstance().getChannels().values()) {
                if (!channel.doAutojoin() || channel.isTemporary() || !chatter.hasPermission(channel, "subscribe")) continue;
                chatter.subscribe(channel);
            }
            return chatter;
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Unable to create Chatter '" + player.getUsername() + "'/" + String.valueOf(player.getUniqueId()), e);
            return null;
        }
    }

    public InputStream getResourceAsStream(String name) {
        return this.getClass().getClassLoader().getResourceAsStream(name);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public File getDataFolder() {
        return this.dataFolder.toFile();
    }

    public ProxyServer getProxy() {
        return this.proxy;
    }

    static {
        luckPermsApi = null;
        uuidDb = null;
        vnpVelocity = null;
    }

    private class ChatterNotFoundException
    extends ExecutionException {
        ChatterNotFoundException(String msg) {
            super(msg);
        }
    }
}

