/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.proxy.ServerConnection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.kyori.adventure.text.format.TextColor;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.config.ChannelConfig;
import net.zaiyers.Channels.config.ChannelYamlConfig;
import net.zaiyers.Channels.message.ChannelMessage;
import net.zaiyers.Channels.message.ConsoleMessage;
import net.zaiyers.Channels.message.Message;

public class Channel {
    private boolean temporary = false;
    private Set<UUID> subscribers = new HashSet<UUID>();
    private ChannelConfig cfg;

    public void subscribe(Chatter chatter) {
        if (this.cfg.getBans().contains(chatter.getPlayer().getUniqueId().toString())) {
            Channels.notify((CommandSource)chatter.getPlayer(), "channels.chatter.banned-from-channel", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.getName(), (Object)"channelColor", (Object)this.getColor().toString()));
            chatter.unsubscribe(this.getUUID());
            return;
        }
        if (!this.subscribers.contains(chatter.getPlayer().getUniqueId())) {
            this.subscribers.add(chatter.getPlayer().getUniqueId());
        }
    }

    public void unsubscribe(Chatter chatter) {
        this.unsubscribe(chatter.getPlayer().getUniqueId());
    }

    private void unsubscribe(UUID subscriberId) {
        this.subscribers.remove(subscriberId);
        if (this.temporary && this.subscribers.size() == 0) {
            Channels.getInstance().removeChannel(this.cfg.getUUID());
        }
    }

    public Channel(String uuid) throws IOException {
        this.cfg = new ChannelYamlConfig(new File(Channels.getInstance().getDataFolder().getAbsolutePath(), "channels" + File.separatorChar + uuid + ".yml"));
    }

    public String getName() {
        return this.cfg.getName();
    }

    public String getUUID() {
        return this.cfg.getUUID();
    }

    public void send(ChannelMessage message, boolean hidden) {
        Chatter sender = message.getChatter();
        if (sender.isMuted()) {
            Channels.notify((CommandSource)sender.getPlayer(), "channels.chatter.is-muted", new String[0]);
            return;
        }
        if (sender.getPlayer().getCurrentServer().isPresent()) {
            String serverName = ((ServerConnection)sender.getPlayer().getCurrentServer().get()).getServerInfo().getName();
            if (!(this.cfg.isGlobal() || sender.hasPermission(this, "globalread") || this.cfg.getServers().contains(serverName))) {
                Channels.notify((CommandSource)sender.getPlayer(), "channels.command.channel-not-available", (Map<String, String>)ImmutableMap.of((Object)"channelColor", (Object)this.getColor().toString(), (Object)"channel", (Object)this.getName(), (Object)"server", (Object)serverName));
                return;
            }
        }
        Chatter messageSender = sender.hasPermission("channels.bypass.ignore") ? null : sender;
        this.send(messageSender, message, hidden);
    }

    public void send(ConsoleMessage consoleMessage, boolean hidden) {
        this.send(null, consoleMessage, hidden);
    }

    public void send(Chatter messageSender, Message message, boolean hidden) {
        ArrayList<UUID> subCur = new ArrayList<UUID>(this.subscribers);
        for (UUID uuid : subCur) {
            Chatter receiver = Channels.getInstance().getChatter(uuid);
            if (receiver != null && receiver.getPlayer() != null) {
                if (messageSender != null && receiver.getIgnores().contains(messageSender.getPlayer().getUniqueId().toString()) || !this.cfg.isGlobal() && !receiver.hasPermission(this, "globalread") && receiver.getPlayer().getCurrentServer().isPresent() && !this.cfg.getServers().contains(((ServerConnection)receiver.getPlayer().getCurrentServer().get()).getServerInfo().getName()) || hidden && messageSender != receiver || !receiver.canSeeChat()) continue;
                receiver.sendMessage(messageSender, message);
                continue;
            }
            this.unsubscribe(uuid);
        }
    }

    public String getFormat() {
        return this.cfg.getFormat();
    }

    public TextColor getColor() {
        return this.cfg.getColor();
    }

    public String getTag() {
        return this.cfg.getTag();
    }

    public void setName(String name) {
        this.cfg.setName(name);
    }

    public void setTag(String tag) {
        this.cfg.setTag(tag);
    }

    public void setFormat(String format) {
        this.cfg.setFormat(format.replace("\\n", "\n"));
    }

    public void setPassword(String password) {
        this.cfg.setPassword(password);
    }

    public void save() {
        if (!this.temporary) {
            this.cfg.save();
        }
    }

    public String getPassword() {
        return this.cfg.getPassword();
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setGlobal(boolean global) {
        this.cfg.setGlobal(global);
    }

    public void setBackend(boolean backend) {
        this.cfg.setBackend(backend);
    }

    public void addServer(String servername) {
        this.cfg.addServer(servername);
    }

    public void removeServer(String servername) {
        this.cfg.removeServer(servername);
    }

    public void setTemporary(boolean b) {
        this.temporary = b;
    }

    public void addModerator(String uuid) {
        this.cfg.addModerator(uuid);
    }

    public boolean isMod(String uuid) {
        return this.cfg.getModerators().contains(uuid);
    }

    public List<String> getModerators() {
        return this.cfg.getModerators();
    }

    public void removeModerator(String modUUID) {
        this.cfg.removeModerator(modUUID);
    }

    public void setAutojoin(boolean b) {
        this.cfg.setAutojoin(b);
    }

    public boolean doAutojoin() {
        return this.cfg.doAutojoin();
    }

    public void setAutofocus(boolean b) {
        this.cfg.setAutofocus(b);
    }

    public boolean doAutofocus() {
        return this.cfg.doAutofocus();
    }

    public void banChatter(UUID chatterUUID) {
        this.cfg.addBan(chatterUUID.toString());
        Chatter chatter = Channels.getInstance().getChatter(chatterUUID);
        if (chatter != null) {
            chatter.unsubscribe(this.getUUID());
            Channels.notify((CommandSource)chatter.getPlayer(), "channels.chatter.banned-me-from-channel", (Map<String, String>)ImmutableMap.of((Object)"channelColor", (Object)this.getColor().toString(), (Object)"channel", (Object)this.getName()));
        }
        String banned = Channels.getPlayerName(chatterUUID);
        this.notifySubscribers("channels.chatter.banned-from-channel", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)banned, (Object)"channelColor", (Object)this.getColor().toString(), (Object)"channel", (Object)this.getName()));
    }

    public void kickChatter(String chatterUUID) {
        Chatter chatter = Channels.getInstance().getChatter(chatterUUID);
        if (chatter != null) {
            chatter.unsubscribe(this.getUUID());
            Channels.notify((CommandSource)chatter.getPlayer(), "channels.chatter.kicked-me-from-channel", (Map<String, String>)ImmutableMap.of((Object)"channelColor", (Object)this.getColor().toString(), (Object)"channel", (Object)this.getName()));
        }
        this.notifySubscribers("channels.chatter.kicked-from-channel", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)Channels.getPlayerName(chatterUUID), (Object)"channelColor", (Object)this.getColor().toString(), (Object)"channel", (Object)this.getName()));
    }

    public void unbanChatter(UUID chatterUUID) {
        this.cfg.removeBan(chatterUUID.toString());
        String banned = Channels.getPlayerName(chatterUUID);
        for (UUID subscriber : this.subscribers) {
            this.notifySubscribers("channels.chatter.unbanned-from-channel", (Map<String, String>)ImmutableMap.of((Object)"chatter", (Object)banned, (Object)"channelColor", (Object)this.getColor().toString(), (Object)"channel", (Object)this.getName()));
        }
    }

    public void setColor(TextColor color) {
        this.cfg.setColor(color);
    }

    public boolean isGlobal() {
        return this.cfg.isGlobal();
    }

    public boolean isBackend() {
        return this.cfg.isBackend();
    }

    public List<String> getServers() {
        return this.cfg.getServers();
    }

    @Deprecated
    public List<String> getSubscribers() {
        return this.subscribers.stream().map(UUID::toString).collect(Collectors.toList());
    }

    public Collection<UUID> getSubscriberUUIDs() {
        return this.subscribers;
    }

    public List<String> getBans() {
        return this.cfg.getBans();
    }

    public void removeChannel() {
        this.notifySubscribers("channels.command.channel-removed", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)this.getName(), (Object)"channelColor", (Object)this.getColor().toString()));
        this.cfg.removeConfig();
    }

    private void notifySubscribers(String messageKey, Map<String, String> replacements) {
        for (UUID subscriberUUID : this.subscribers) {
            Chatter chatter = Channels.getInstance().getChatter(subscriberUUID);
            if (chatter != null && chatter.getPlayer() != null) {
                Channels.notify((CommandSource)chatter.getPlayer(), messageKey, replacements);
                continue;
            }
            this.unsubscribe(subscriberUUID);
        }
    }
}

