/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.listener;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.zaiyers.Channels.Channel;
import net.zaiyers.Channels.Channels;
import net.zaiyers.Channels.Chatter;
import net.zaiyers.Channels.command.PMCommand;
import net.zaiyers.Channels.events.ChannelsChatEvent;
import net.zaiyers.Channels.message.ChannelMessage;
import net.zaiyers.Channels.message.PrivateMessage;

public class MessageListener
implements Listener {
    @EventHandler(priority=64)
    public void onMessageRecieve(ChatEvent event) {
        if (event.isCancelled() || !(event.getSender() instanceof ProxiedPlayer) || event.isCommand()) {
            return;
        }
        boolean canceled = true;
        ProxiedPlayer player = (ProxiedPlayer)event.getSender();
        if (event.getMessage().charAt(0) == '@' && event.getMessage().length() > 0) {
            String[] splittedMsg;
            if (event.getMessage().length() > 1) {
                splittedMsg = event.getMessage().split(" ");
                splittedMsg[0] = splittedMsg[0].substring(1);
            } else {
                splittedMsg = new String[]{};
            }
            PMCommand cmd = new PMCommand((CommandSender)player, splittedMsg);
            cmd.execute();
        } else {
            Chatter chatter = Channels.getInstance().getChatter(player);
            if (chatter.getLastRecipient() != null) {
                Chatter recipient = Channels.getInstance().getChatter(chatter.getLastRecipient());
                if (recipient == null) {
                    Channels.notify((CommandSender)player, "channels.chatter.recipient-offline", new String[0]);
                } else {
                    PrivateMessage msg = new PrivateMessage(chatter, recipient, event.getMessage());
                    ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
                    if (!((ChannelsChatEvent)Channels.getInstance().getProxy().getPluginManager().callEvent((Event)chatEvent)).isCancelled()) {
                        msg.send(chatEvent.isHidden());
                        if (!chatEvent.isHidden()) {
                            recipient.setLastPrivateSender(chatter);
                        }
                    }
                }
            } else {
                Channel chan = Channels.getInstance().getChannel(chatter.getChannel());
                if (chatter.hasPermission(chan, "speak")) {
                    if (!chan.isGlobal() && !chan.getServers().contains(chatter.getPlayer().getServer().getInfo().getName())) {
                        String serverDefaultChannel = Channels.getConfig().getServerDefaultChannel(chatter.getPlayer().getServer().getInfo().getName());
                        chan = serverDefaultChannel != null ? Channels.getInstance().getChannel(serverDefaultChannel) : Channels.getInstance().getChannel(Channels.getConfig().getDefaultChannelUUID());
                        if (chan != null && chan.doAutojoin() && chatter.hasPermission(chan, "subscribe")) {
                            chatter.setDefaultChannelUUID(chan.getUUID());
                            chatter.subscribe(chan);
                            Channels.notify((CommandSender)chatter.getPlayer(), "channels.chatter.default-channel-set", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                        } else {
                            event.setCancelled(true);
                            return;
                        }
                    }
                    ChannelMessage msg = new ChannelMessage(chatter, chan, event.getMessage());
                    ChannelsChatEvent chatEvent = new ChannelsChatEvent(msg);
                    if (!((ChannelsChatEvent)Channels.getInstance().getProxy().getPluginManager().callEvent((Event)chatEvent)).isCancelled()) {
                        if (msg.getChannel().isBackend()) {
                            canceled = false;
                        } else {
                            msg.send(chatEvent.isHidden());
                        }
                    }
                } else {
                    Channels.notify((CommandSender)chatter.getPlayer(), "channels.permission.channel-no-speak", (Map<String, String>)ImmutableMap.of((Object)"channel", (Object)chan.getName(), (Object)"channelColor", (Object)chan.getColor().toString()));
                }
            }
        }
        event.setCancelled(canceled);
    }
}

