/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.zaiyers.Channels.lib.bson.BsonArray;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.codecs.BsonArrayCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonBinaryCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonBooleanCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonDBPointerCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonDateTimeCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonDecimal128Codec;
import net.zaiyers.Channels.lib.bson.codecs.BsonDocumentCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonDoubleCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonInt32Codec;
import net.zaiyers.Channels.lib.bson.codecs.BsonInt64Codec;
import net.zaiyers.Channels.lib.bson.codecs.BsonJavaScriptCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonJavaScriptWithScopeCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonMaxKeyCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonMinKeyCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonNullCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonObjectIdCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonRegularExpressionCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonStringCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonSymbolCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonTimestampCodec;
import net.zaiyers.Channels.lib.bson.codecs.BsonUndefinedCodec;
import net.zaiyers.Channels.lib.bson.codecs.Codec;
import net.zaiyers.Channels.lib.bson.codecs.Decoder;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecProvider;
import net.zaiyers.Channels.lib.bson.codecs.configuration.CodecRegistry;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandResultDocumentCodec;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
        this.addCodec(new BsonJavaScriptWithScopeCodec(new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result = this.payloadDecoder.getClass().hashCode();
        result = 31 * result + this.fieldsContainingPayload.hashCode();
        return result;
    }
}

