/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.operation;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.zaiyers.Channels.lib.bson.BsonArray;
import net.zaiyers.Channels.lib.bson.BsonBoolean;
import net.zaiyers.Channels.lib.bson.BsonDocument;
import net.zaiyers.Channels.lib.bson.BsonInt32;
import net.zaiyers.Channels.lib.bson.BsonInt64;
import net.zaiyers.Channels.lib.bson.BsonString;
import net.zaiyers.Channels.lib.bson.BsonValue;
import net.zaiyers.Channels.lib.bson.codecs.Decoder;
import net.zaiyers.Channels.lib.mongodb.MongoNamespace;
import net.zaiyers.Channels.lib.mongodb.assertions.Assertions;
import net.zaiyers.Channels.lib.mongodb.client.model.Collation;
import net.zaiyers.Channels.lib.mongodb.connection.ConnectionDescription;
import net.zaiyers.Channels.lib.mongodb.internal.async.AsyncBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.async.ErrorHandlingResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.binding.AsyncReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.binding.ReadBinding;
import net.zaiyers.Channels.lib.mongodb.internal.client.model.AggregationLevel;
import net.zaiyers.Channels.lib.mongodb.internal.connection.QueryResult;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AggregateResponseBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AsyncQueryBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.AsyncReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.operation.BatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandOperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.CommandResultDocumentCodec;
import net.zaiyers.Channels.lib.mongodb.internal.operation.OperationHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.OperationReadConcernHelper;
import net.zaiyers.Channels.lib.mongodb.internal.operation.QueryBatchCursor;
import net.zaiyers.Channels.lib.mongodb.internal.operation.ReadOperation;
import net.zaiyers.Channels.lib.mongodb.internal.session.SessionContext;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

class AggregateOperationImpl<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String CURSOR = "cursor";
    private static final String FIRST_BATCH = "firstBatch";
    private static final List<String> FIELD_NAMES_WITH_RESULT = Arrays.asList("result", "firstBatch");
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private final AggregateTarget aggregateTarget;
    private final PipelineCreator pipelineCreator;
    private boolean retryReads;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private long maxAwaitTimeMS;
    private long maxTimeMS;
    private BsonDocument variables;

    AggregateOperationImpl(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this(namespace, pipeline, decoder, AggregateOperationImpl.defaultAggregateTarget(Assertions.notNull("aggregationLevel", aggregationLevel), Assertions.notNull("namespace", namespace).getCollectionName()), AggregateOperationImpl.defaultPipelineCreator(pipeline));
    }

    AggregateOperationImpl(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregateTarget aggregateTarget, PipelineCreator pipelineCreator) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.aggregateTarget = Assertions.notNull("aggregateTarget", aggregateTarget);
        this.pipelineCreator = Assertions.notNull("pipelineCreator", pipelineCreator);
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    Decoder<T> getDecoder() {
        return this.decoder;
    }

    Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    AggregateOperationImpl<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    Integer getBatchSize() {
        return this.batchSize;
    }

    AggregateOperationImpl<T> batchSize(@Nullable Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    long getMaxAwaitTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS);
    }

    AggregateOperationImpl<T> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxAwaitTime >= 0", maxAwaitTime >= 0L);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    AggregateOperationImpl<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        Assertions.isTrueArgument("maxTime >= 0", maxTime >= 0L);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    Collation getCollation() {
        return this.collation;
    }

    AggregateOperationImpl<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    BsonValue getComment() {
        return this.comment;
    }

    AggregateOperationImpl<T> comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    AggregateOperationImpl<T> let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    AggregateOperationImpl<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    BsonValue getHint() {
        return this.hint;
    }

    AggregateOperationImpl<T> hint(@Nullable BsonValue hint) {
        Assertions.isTrueArgument("BsonString or BsonDocument", hint == null || hint.isDocument() || hint.isString());
        this.hint = hint;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return CommandOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        SingleResultCallback<AsyncBatchCursor<T>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        CommandOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(binding.getSessionContext()), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.asyncTransformer(), this.retryReads, errHandlingCallback);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator(SessionContext sessionContext) {
        return (serverDescription, connectionDescription) -> this.getCommand(sessionContext, connectionDescription.getMaxWireVersion());
    }

    BsonDocument getCommand(SessionContext sessionContext, int maxWireVersion) {
        BsonDocument commandDocument = new BsonDocument("aggregate", this.aggregateTarget.create());
        OperationReadConcernHelper.appendReadConcernToCommand(sessionContext, maxWireVersion, commandDocument);
        commandDocument.put("pipeline", this.pipelineCreator.create());
        if (this.maxTimeMS > 0L) {
            commandDocument.put("maxTimeMS", this.maxTimeMS > Integer.MAX_VALUE ? new BsonInt64(this.maxTimeMS) : new BsonInt32((int)this.maxTimeMS));
        }
        BsonDocument cursor = new BsonDocument();
        if (this.batchSize != null) {
            cursor.put("batchSize", new BsonInt32(this.batchSize));
        }
        commandDocument.put(CURSOR, cursor);
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", this.variables);
        }
        return commandDocument;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return OperationHelper.cursorDocumentToQueryResult(result.getDocument(CURSOR), description.getServerAddress());
    }

    private CommandOperationHelper.CommandReadTransformer<BsonDocument, AggregateResponseBatchCursor<T>> transformer() {
        return (result, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result, connection.getDescription());
            return new QueryBatchCursor<T>(queryResult, 0, this.batchSize != null ? this.batchSize : 0, this.maxAwaitTimeMS, this.decoder, this.comment, source, connection, (BsonDocument)result);
        };
    }

    private CommandOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> {
            QueryResult<T> queryResult = this.createQueryResult((BsonDocument)result, connection.getDescription());
            return new AsyncQueryBatchCursor<T>(queryResult, 0, this.batchSize != null ? this.batchSize : 0, this.maxAwaitTimeMS, this.decoder, this.comment, source, connection, (BsonDocument)result);
        };
    }

    private static AggregateTarget defaultAggregateTarget(AggregationLevel aggregationLevel, String collectionName) {
        return () -> {
            if (aggregationLevel == AggregationLevel.DATABASE) {
                return new BsonInt32(1);
            }
            return new BsonString(collectionName);
        };
    }

    private static PipelineCreator defaultPipelineCreator(List<BsonDocument> pipeline) {
        return () -> new BsonArray(pipeline);
    }

    static interface AggregateTarget {
        public BsonValue create();
    }

    static interface PipelineCreator {
        public BsonArray create();
    }
}

