/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.util.List;
import net.zaiyers.Channels.lib.mongodb.LoggerSettings;
import net.zaiyers.Channels.lib.mongodb.MongoCompressor;
import net.zaiyers.Channels.lib.mongodb.MongoCredential;
import net.zaiyers.Channels.lib.mongodb.MongoDriverInformation;
import net.zaiyers.Channels.lib.mongodb.ServerAddress;
import net.zaiyers.Channels.lib.mongodb.ServerApi;
import net.zaiyers.Channels.lib.mongodb.annotations.ThreadSafe;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.connection.ConnectionPoolSettings;
import net.zaiyers.Channels.lib.mongodb.connection.ServerId;
import net.zaiyers.Channels.lib.mongodb.connection.ServerSettings;
import net.zaiyers.Channels.lib.mongodb.connection.StreamFactory;
import net.zaiyers.Channels.lib.mongodb.event.CommandListener;
import net.zaiyers.Channels.lib.mongodb.internal.connection.Cluster;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterableServer;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterableServerFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultConnectionFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultConnectionPool;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalConnectionPoolSettings;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalStreamConnectionFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.LoadBalancedServer;
import net.zaiyers.Channels.lib.mongodb.internal.connection.MongoCredentialWithCache;
import net.zaiyers.Channels.lib.mongodb.internal.event.EventListenerHelper;
import net.zaiyers.Channels.lib.mongodb.internal.inject.EmptyProvider;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

@ThreadSafe
public class LoadBalancedClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    private final ServerApi serverApi;

    public LoadBalancedClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(new ServerId(cluster.getClusterId(), serverAddress), new InternalStreamConnectionFactory(ClusterConnectionMode.LOAD_BALANCED, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, EmptyProvider.instance());
        connectionPool.ready();
        return new LoadBalancedServer(new ServerId(cluster.getClusterId(), serverAddress), connectionPool, new DefaultConnectionFactory(), EventListenerHelper.singleServerListener(this.serverSettings), cluster.getClock());
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

