/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.connection;

import java.util.Collections;
import java.util.List;
import net.zaiyers.Channels.lib.mongodb.LoggerSettings;
import net.zaiyers.Channels.lib.mongodb.MongoCompressor;
import net.zaiyers.Channels.lib.mongodb.MongoCredential;
import net.zaiyers.Channels.lib.mongodb.MongoDriverInformation;
import net.zaiyers.Channels.lib.mongodb.ServerAddress;
import net.zaiyers.Channels.lib.mongodb.ServerApi;
import net.zaiyers.Channels.lib.mongodb.connection.ClusterConnectionMode;
import net.zaiyers.Channels.lib.mongodb.connection.ConnectionPoolSettings;
import net.zaiyers.Channels.lib.mongodb.connection.ServerId;
import net.zaiyers.Channels.lib.mongodb.connection.ServerSettings;
import net.zaiyers.Channels.lib.mongodb.connection.StreamFactory;
import net.zaiyers.Channels.lib.mongodb.event.CommandListener;
import net.zaiyers.Channels.lib.mongodb.event.ServerListener;
import net.zaiyers.Channels.lib.mongodb.internal.connection.Cluster;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterableServer;
import net.zaiyers.Channels.lib.mongodb.internal.connection.ClusterableServerFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultConnectionFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultConnectionPool;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultSdamServerDescriptionManager;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultServer;
import net.zaiyers.Channels.lib.mongodb.internal.connection.DefaultServerMonitor;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalConnectionPoolSettings;
import net.zaiyers.Channels.lib.mongodb.internal.connection.InternalStreamConnectionFactory;
import net.zaiyers.Channels.lib.mongodb.internal.connection.MongoCredentialWithCache;
import net.zaiyers.Channels.lib.mongodb.internal.connection.SdamServerDescriptionManager;
import net.zaiyers.Channels.lib.mongodb.internal.event.EventListenerHelper;
import net.zaiyers.Channels.lib.mongodb.internal.inject.SameObjectProvider;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

public class DefaultClusterableServerFactory
implements ClusterableServerFactory {
    private final ServerSettings serverSettings;
    private final ConnectionPoolSettings connectionPoolSettings;
    private final InternalConnectionPoolSettings internalConnectionPoolSettings;
    private final StreamFactory streamFactory;
    private final MongoCredentialWithCache credential;
    private final StreamFactory heartbeatStreamFactory;
    private final LoggerSettings loggerSettings;
    private final CommandListener commandListener;
    private final String applicationName;
    private final MongoDriverInformation mongoDriverInformation;
    private final List<MongoCompressor> compressorList;
    @Nullable
    private final ServerApi serverApi;

    public DefaultClusterableServerFactory(ServerSettings serverSettings, ConnectionPoolSettings connectionPoolSettings, InternalConnectionPoolSettings internalConnectionPoolSettings, StreamFactory streamFactory, StreamFactory heartbeatStreamFactory, @Nullable MongoCredential credential, LoggerSettings loggerSettings, @Nullable CommandListener commandListener, @Nullable String applicationName, @Nullable MongoDriverInformation mongoDriverInformation, List<MongoCompressor> compressorList, @Nullable ServerApi serverApi) {
        this.serverSettings = serverSettings;
        this.connectionPoolSettings = connectionPoolSettings;
        this.internalConnectionPoolSettings = internalConnectionPoolSettings;
        this.streamFactory = streamFactory;
        this.credential = credential == null ? null : new MongoCredentialWithCache(credential);
        this.heartbeatStreamFactory = heartbeatStreamFactory;
        this.loggerSettings = loggerSettings;
        this.commandListener = commandListener;
        this.applicationName = applicationName;
        this.mongoDriverInformation = mongoDriverInformation;
        this.compressorList = compressorList;
        this.serverApi = serverApi;
    }

    @Override
    public ClusterableServer create(Cluster cluster, ServerAddress serverAddress) {
        ServerId serverId = new ServerId(cluster.getClusterId(), serverAddress);
        ClusterConnectionMode clusterMode = cluster.getSettings().getMode();
        SameObjectProvider<SdamServerDescriptionManager> sdamProvider = SameObjectProvider.uninitialized();
        DefaultServerMonitor serverMonitor = new DefaultServerMonitor(serverId, this.serverSettings, cluster.getClock(), new InternalStreamConnectionFactory(clusterMode, true, this.heartbeatStreamFactory, null, this.applicationName, this.mongoDriverInformation, Collections.emptyList(), this.loggerSettings, null, this.serverApi), clusterMode, this.serverApi, sdamProvider);
        DefaultConnectionPool connectionPool = new DefaultConnectionPool(serverId, new InternalStreamConnectionFactory(clusterMode, this.streamFactory, this.credential, this.applicationName, this.mongoDriverInformation, this.compressorList, this.loggerSettings, this.commandListener, this.serverApi), this.connectionPoolSettings, this.internalConnectionPoolSettings, sdamProvider);
        ServerListener serverListener = EventListenerHelper.singleServerListener(this.serverSettings);
        DefaultSdamServerDescriptionManager sdam = new DefaultSdamServerDescriptionManager(cluster, serverId, serverListener, serverMonitor, connectionPool, clusterMode);
        sdamProvider.initialize(sdam);
        serverMonitor.start();
        return new DefaultServer(serverId, clusterMode, connectionPool, new DefaultConnectionFactory(), serverMonitor, sdam, serverListener, this.commandListener, cluster.getClock(), true);
    }

    @Override
    public ServerSettings getSettings() {
        return this.serverSettings;
    }
}

