/*
 * Decompiled with CFR 0.152.
 */
package net.zaiyers.Channels.lib.mongodb.internal.async.function;

import net.zaiyers.Channels.lib.mongodb.annotations.NotThreadSafe;
import net.zaiyers.Channels.lib.mongodb.internal.async.SingleResultCallback;
import net.zaiyers.Channels.lib.mongodb.internal.async.function.AsyncCallbackRunnable;
import net.zaiyers.Channels.lib.mongodb.internal.async.function.LoopState;
import net.zaiyers.Channels.lib.mongodb.lang.Nullable;

@NotThreadSafe
public final class AsyncCallbackLoop
implements AsyncCallbackRunnable {
    private final LoopState state;
    private final AsyncCallbackRunnable body;

    public AsyncCallbackLoop(LoopState state, AsyncCallbackRunnable body) {
        this.state = state;
        this.body = body;
    }

    @Override
    public void run(SingleResultCallback<Void> callback) {
        this.body.run(new LoopingCallback(callback));
    }

    @NotThreadSafe
    private class LoopingCallback
    implements SingleResultCallback<Void> {
        private final SingleResultCallback<Void> wrapped;

        LoopingCallback(SingleResultCallback<Void> callback) {
            this.wrapped = callback;
        }

        @Override
        public void onResult(@Nullable Void result, @Nullable Throwable t) {
            if (t != null) {
                this.wrapped.onResult(null, t);
            } else {
                boolean continueLooping;
                try {
                    continueLooping = AsyncCallbackLoop.this.state.advance();
                }
                catch (Throwable e) {
                    this.wrapped.onResult(null, e);
                    return;
                }
                if (continueLooping) {
                    AsyncCallbackLoop.this.body.run(this);
                } else {
                    this.wrapped.onResult(result, null);
                }
            }
        }
    }
}

